/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.Collections;
import java.util.List;

public class NullNode
implements ScalarNode {
    private final Token token;
    private final CharSource source;

    public NullNode(Token token, CharSource source) {
        this.token = token;
        this.source = source;
    }

    @Override
    public NodeType type() {
        return NodeType.NULL;
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    @Override
    public Token rootElementToken() {
        return this.token;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public int length() {
        return 4;
    }

    @Override
    public char charAt(int index) {
        switch (index) {
            case 0: {
                return 'n';
            }
            case 1: {
                return 'u';
            }
            case 2: 
            case 3: {
                return 'l';
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public String toString() {
        return "null";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

