/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.node.support.CharSequenceUtils;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;

public class NumberNode
extends Number
implements ScalarNode,
CharSequence {
    private final Token token;
    private final CharSource source;
    private final NodeType elementType;
    private boolean hashCodeSet;
    private int hashCode;

    public NumberNode(Token token, CharSource source, NodeType elementType) {
        this.token = token;
        this.source = source;
        this.elementType = elementType;
    }

    @Override
    public int intValue() {
        return this.source.getInt(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public long longValue() {
        return this.source.getLong(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public float floatValue() {
        return this.source.getFloat(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public double doubleValue() {
        return this.source.getDouble(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.source.getBigDecimal(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.source.getBigInteger(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public Object value() {
        if (this.isInteger()) {
            return this.intValue();
        }
        if (this.isLong()) {
            return this.longValue();
        }
        return this.doubleValue();
    }

    @Override
    public NodeType type() {
        return this.elementType;
    }

    @Override
    public int length() {
        return this.token.endIndex - this.token.startIndex;
    }

    @Override
    public char charAt(int index) {
        if (index > this.length()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.source.getChartAt(this.token.startIndex + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return this.source.getCharSequence(start + this.token.startIndex, end + this.token.startIndex);
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    @Override
    public Token rootElementToken() {
        return this.token;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof NumberNode) {
            NumberNode other = (NumberNode)o;
            return CharSequenceUtils.equals(this, other);
        }
        if (o instanceof Number) {
            switch (o.getClass().getName()) {
                case "java.lang.Integer": {
                    return this.intValue() == ((Integer)o).intValue();
                }
                case "java.lang.Long": {
                    return this.longValue() == ((Long)o).longValue();
                }
                case "java.lang.Float": {
                    return this.floatValue() == ((Float)o).floatValue();
                }
                case "java.lang.Double": {
                    return this.doubleValue() == ((Double)o).doubleValue();
                }
                case "java.math.BigDecimal": {
                    return this.bigDecimalValue().equals(o);
                }
                case "java.math.BigInteger": {
                    return this.bigIntegerValue().equals(o);
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = CharSequenceUtils.hashCode(this);
        this.hashCodeSet = true;
        return this.hashCode;
    }

    public boolean isInteger() {
        switch (this.elementType) {
            case INT: {
                return this.source.isInteger(this.token.startIndex, this.token.endIndex);
            }
        }
        return false;
    }

    public boolean isLong() {
        switch (this.elementType) {
            case INT: {
                return !this.source.isInteger(this.token.startIndex, this.token.endIndex);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return this.originalString();
    }
}

