/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.ArrayNode;
import io.nats.jparse.node.BooleanNode;
import io.nats.jparse.node.CollectionNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.NullNode;
import io.nats.jparse.node.NumberNode;
import io.nats.jparse.node.StringNode;
import io.nats.jparse.node.support.NodeUtils;
import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import io.nats.jparse.token.TokenTypes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ObjectNode
extends AbstractMap<CharSequence, Node>
implements CollectionNode {
    private final TokenSubList tokens;
    private final CharSource source;
    private final Token rootToken;
    private final boolean objectsKeysCanBeEncoded;
    private List<List<Token>> childrenTokens;
    private Map<Object, Node> elementMap;
    private List<CharSequence> keys;
    private boolean hashCodeSet;
    private int hashCode;

    public ObjectNode(TokenSubList tokens, CharSource source, boolean objectsKeysCanBeEncoded) {
        this.tokens = tokens;
        this.source = source;
        this.rootToken = tokens.get(0);
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
    }

    @Override
    public List<List<Token>> childrenTokens() {
        if (this.childrenTokens == null) {
            this.childrenTokens = NodeUtils.getChildrenTokens(this.tokens);
        }
        return this.childrenTokens;
    }

    @Override
    public Node getNode(Object key) {
        return this.lookupElement((CharSequence)key);
    }

    public List<CharSequence> getKeys() {
        return this.keys();
    }

    @Override
    public int length() {
        return this.childrenTokens().size() / 2;
    }

    @Override
    public NodeType type() {
        return NodeType.OBJECT;
    }

    @Override
    public List<Token> tokens() {
        return this.tokens;
    }

    @Override
    public Token rootElementToken() {
        return this.rootToken;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public Node get(Object key) {
        Node value = this.getNode(key);
        return value instanceof NullNode ? null : value;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.lookupElement((CharSequence)key) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.keys().isEmpty();
    }

    @Override
    public int size() {
        return this.keys().size();
    }

    @Override
    public Set<CharSequence> keySet() {
        return this.keys().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    @Override
    public Collection<Node> values() {
        return this.keys().stream().map(this::lookupElement).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<CharSequence, Node>> entrySet() {
        return new AbstractSet<Map.Entry<CharSequence, Node>>(){

            @Override
            public boolean contains(Object o) {
                return ObjectNode.this.keys().contains(o);
            }

            @Override
            public Iterator<Map.Entry<CharSequence, Node>> iterator() {
                final Iterator iterator = ObjectNode.this.keys().iterator();
                return new Iterator<Map.Entry<CharSequence, Node>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<CharSequence, Node> next() {
                        final String nextKey = ((CharSequence)iterator.next()).toString();
                        return new Map.Entry<CharSequence, Node>(){

                            @Override
                            public CharSequence getKey() {
                                return nextKey;
                            }

                            @Override
                            public Node getValue() {
                                return ObjectNode.this.lookupElement(nextKey);
                            }

                            @Override
                            public Node setValue(Node value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return ObjectNode.this.keys().size();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectNode)) {
            return false;
        }
        ObjectNode other = (ObjectNode)o;
        if (this.tokens.size() != other.tokens.size()) {
            return false;
        }
        List<CharSequence> keys = this.keys();
        List<CharSequence> otherKeys = other.keys();
        if (keys.size() != otherKeys.size()) {
            return false;
        }
        for (CharSequence key : keys) {
            Node otherElementValue = other.getNode(key);
            Node thisElementValue = this.getNode(key);
            if (otherElementValue == null) {
                return false;
            }
            if (otherElementValue.equals(thisElementValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        List<CharSequence> keys = this.keys();
        for (CharSequence key : keys) {
            this.getNode(key);
        }
        this.hashCode = this.elementMap.hashCode();
        this.hashCodeSet = true;
        return this.hashCode;
    }

    public NumberNode getNumberNode(CharSequence key) {
        return (NumberNode)this.getNode(key);
    }

    public NullNode getNullNode(CharSequence key) {
        return (NullNode)this.getNode(key);
    }

    public long getLong(CharSequence key) {
        return ((NumberNode)this.getNode(key)).longValue();
    }

    public double getDouble(CharSequence key) {
        return ((NumberNode)this.getNode(key)).doubleValue();
    }

    public int getInt(CharSequence key) {
        return ((NumberNode)this.getNode(key)).intValue();
    }

    public float getFloat(CharSequence key) {
        return ((NumberNode)this.getNode(key)).floatValue();
    }

    public BigDecimal getBigDecimal(CharSequence key) {
        return this.getNumberNode(key).bigDecimalValue();
    }

    public BigInteger getBigInteger(CharSequence key) {
        return this.getNumberNode(key).bigIntegerValue();
    }

    public StringNode getStringNode(CharSequence key) {
        return (StringNode)this.getNode(key);
    }

    public String getString(CharSequence key) {
        return this.getStringNode(key).toString();
    }

    public ObjectNode getObjectNode(CharSequence key) {
        return (ObjectNode)this.getNode(key);
    }

    public ArrayNode getArrayNode(CharSequence key) {
        return (ArrayNode)this.getNode(key);
    }

    public BooleanNode getBooleanNode(CharSequence key) {
        return (BooleanNode)this.getNode(key);
    }

    public boolean getBoolean(CharSequence key) {
        return this.getBooleanNode(key).booleanValue();
    }

    public Optional<Node> getNode(Node key) {
        List<List<Token>> childrenTokens = this.childrenTokens();
        Node node = null;
        for (int index = 0; index < childrenTokens.size(); index += 2) {
            List<Token> itemKey = childrenTokens.get(index);
            if (!this.keyMatch(itemKey, key)) continue;
            node = NodeUtils.createNodeForObject(childrenTokens.get(index + 1), this.source, this.objectsKeysCanBeEncoded);
            break;
        }
        return Optional.ofNullable(node);
    }

    private boolean keyMatch(List<Token> tokens, Node key) {
        return NodeUtils.createNodeForObject(tokens, this.source, this.objectsKeysCanBeEncoded).equals(key);
    }

    private Node lookupElement(CharSequence key) {
        Node node;
        if (this.elementMap == null) {
            this.elementMap = new HashMap<Object, Node>();
        }
        if ((node = this.elementMap.get(key)) == null) {
            List<List<Token>> childrenTokens = this.childrenTokens();
            for (int index = 0; index < childrenTokens.size(); index += 2) {
                List<Token> itemKey = childrenTokens.get(index);
                if (!this.doesMatchKey(itemKey, key)) continue;
                node = NodeUtils.createNodeForObject(childrenTokens.get(index + 1), this.source, this.objectsKeysCanBeEncoded);
                this.elementMap.put(key, node);
                break;
            }
        }
        return node;
    }

    private boolean doesMatchKey(List<Token> itemKey, CharSequence key) {
        Token keyToken = itemKey.get(1);
        if (keyToken.type == 7) {
            if (keyToken.length() != key.length()) {
                return false;
            }
            if (this.objectsKeysCanBeEncoded) {
                StringNode stringNode = new StringNode(keyToken, this.source, this.objectsKeysCanBeEncoded);
                String string = stringNode.toString();
                for (int index = 0; index < key.length(); ++index) {
                    if (string.charAt(index) == key.charAt(index)) continue;
                    return false;
                }
                return true;
            }
            return this.source.matchChars(keyToken.startIndex, keyToken.endIndex, key);
        }
        return false;
    }

    private List<CharSequence> keys() {
        if (this.keys == null) {
            List<List<Token>> childrenTokens = this.childrenTokens();
            this.keys = new ArrayList<CharSequence>(childrenTokens.size() / 2);
            block3: for (int index = 0; index < childrenTokens.size(); index += 2) {
                List<Token> itemKey = childrenTokens.get(index);
                Token keyToken = itemKey.get(1);
                switch (keyToken.type) {
                    case 7: {
                        StringNode element = new StringNode(keyToken, this.source, this.objectsKeysCanBeEncoded);
                        this.keys.add(element);
                        continue block3;
                    }
                    default: {
                        throw new IllegalStateException("Only String are allowed for keys " + TokenTypes.getTypeName(keyToken.type));
                    }
                }
            }
        }
        return this.keys;
    }

    @Override
    public String toString() {
        return this.originalString();
    }
}

