/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.ArrayNode;
import io.nats.jparse.node.BooleanNode;
import io.nats.jparse.node.CollectionNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.NullNode;
import io.nats.jparse.node.NumberNode;
import io.nats.jparse.node.ObjectNode;
import io.nats.jparse.node.StringNode;
import io.nats.jparse.node.support.NodeUtils;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.path.PathNode;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class RootNode
implements CollectionNode {
    private final TokenList tokens;
    private final CharSource source;
    private final Token rootToken;
    private final boolean objectsKeysCanBeEncoded;
    private Node root;

    public RootNode(TokenList tokens, CharSource source, boolean objectsKeysCanBeEncoded) {
        this.tokens = tokens;
        this.source = source;
        this.rootToken = tokens.get(0);
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
    }

    public NodeType getType() {
        return NodeType.tokenTypeToElement(this.rootToken.type);
    }

    @Override
    public Node getNode(Object key) {
        switch (this.rootToken.type) {
            case 0: {
                return this.getObjectNode().getNode(key);
            }
            case 3: {
                return this.getArrayNode().getNode(key);
            }
        }
        return this.doGetNode(key);
    }

    @Override
    public List<List<Token>> childrenTokens() {
        switch (this.rootToken.type) {
            case 0: {
                return this.getObjectNode().childrenTokens();
            }
            case 3: {
                return this.getArrayNode().childrenTokens();
            }
        }
        return this.doGetChildrenTokens();
    }

    private List<List<Token>> doGetChildrenTokens() {
        return ((CollectionNode)this.getNode()).childrenTokens();
    }

    private Node doGetNode(Object key) {
        return ((CollectionNode)this.getNode()).getNode(key);
    }

    public Node getNode() {
        if (this.root == null) {
            this.root = NodeUtils.createNode(new TokenSubList(this.tokens.getTokens(), 0, this.tokens.size()), this.source, this.objectsKeysCanBeEncoded);
        }
        return this.root;
    }

    public PathNode getPathNode() {
        if (this.root == null) {
            this.root = new PathNode((TokenSubList)this.tokens.subList(0, this.tokens.size()), this.charSource());
        }
        return (PathNode)this.root;
    }

    public ObjectNode getObjectNode() {
        return (ObjectNode)this.getNode();
    }

    @Override
    public ArrayNode asArray() {
        return this.getArrayNode();
    }

    @Override
    public ObjectNode asObject() {
        return this.getObjectNode();
    }

    public Map<String, Object> getMap() {
        return this.getObjectNode();
    }

    public StringNode getStringNode() {
        return (StringNode)this.getNode();
    }

    public String getString() {
        return this.getStringNode().toString();
    }

    public int getInt() {
        return this.getNumberNode().intValue();
    }

    public float getFloat() {
        return this.getNumberNode().floatValue();
    }

    public long getLong() {
        return this.getNumberNode().longValue();
    }

    public double getDouble() {
        return this.getNumberNode().doubleValue();
    }

    public BigDecimal getBigDecimal() {
        return this.getNumberNode().bigDecimalValue();
    }

    public BigInteger getBigIntegerValue() {
        return this.getNumberNode().bigIntegerValue();
    }

    public NumberNode getNumberNode() {
        return (NumberNode)this.getNode();
    }

    public BooleanNode getBooleanNode() {
        return (BooleanNode)this.getNode();
    }

    public NullNode getNullNode() {
        return (NullNode)this.getNode();
    }

    public boolean getBoolean() {
        return this.getBooleanNode().booleanValue();
    }

    public ArrayNode getArrayNode() {
        return (ArrayNode)this.getNode();
    }

    @Override
    public NodeType type() {
        return NodeType.ROOT;
    }

    @Override
    public List<Token> tokens() {
        return this.tokens;
    }

    @Override
    public Token rootElementToken() {
        return this.rootToken;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (o instanceof RootNode) {
            RootNode other = (RootNode)o;
            return this.getNode().equals(other.getNode());
        }
        return false;
    }

    public int hashCode() {
        return this.getNode().hashCode();
    }
}

