/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.node.support.CharSequenceUtils;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.Collections;
import java.util.List;

public class StringNode
implements ScalarNode,
CharSequence {
    private final Token token;
    private final CharSource source;
    private final int length;
    private final int start;
    private final int end;
    private final boolean encodeStringByDefault;
    private int hashCode = 0;
    private boolean hashCodeSet = false;

    @Override
    public NodeType type() {
        return NodeType.STRING;
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    @Override
    public Token rootElementToken() {
        return this.token;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public Object value() {
        return this.toString();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.source.getChartAt(this.token.startIndex + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.source.getCharSequence(start + this.start, end + this.start);
    }

    public StringNode(Token token, CharSource source, boolean encodeStringByDefault) {
        this.token = token;
        this.source = source;
        this.start = token.startIndex;
        this.end = token.endIndex;
        this.encodeStringByDefault = encodeStringByDefault;
        this.length = token.endIndex - token.startIndex;
    }

    public StringNode(Token token, CharSource source) {
        this.token = token;
        this.source = source;
        this.start = token.startIndex;
        this.end = token.endIndex;
        this.encodeStringByDefault = true;
        this.length = token.endIndex - token.startIndex;
    }

    public CharSequence charSequence() {
        return this.source.getCharSequence(this.start, this.end);
    }

    @Override
    public String toString() {
        return this.encodeStringByDefault ? this.source.toEncodedStringIfNeeded(this.start, this.end) : this.source.getString(this.start, this.end);
    }

    public String toEncodedString() {
        return this.source.getEncodedString(this.start, this.end);
    }

    public String toUnencodedString() {
        return this.source.getString(this.start, this.end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            return CharSequenceUtils.equals(this, other);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = CharSequenceUtils.hashCode(this);
        this.hashCodeSet = true;
        return this.hashCode;
    }
}

