/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node.support;

public class CharArrayUtils {
    static final char[] controlMap = new char[255];
    static final int[] hexValueMap = new int[255];
    static final int ESCAPE = 92;
    private static final int HEX_10s = 16;
    private static final int HEX_100s = 256;
    private static final int HEX_1000s = 4096;

    private CharArrayUtils() {
    }

    public static String decodeJsonString(char[] chars, int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        char[] builder = new char[CharArrayUtils.calculateLengthAfterEncoding(chars, startIndex, endIndex, length)];
        int index = startIndex;
        int idx = 0;
        while (true) {
            char c;
            if ((c = chars[index]) == '\\' && index < endIndex - 1) {
                if ((c = chars[++index]) != 'u') {
                    builder[idx] = controlMap[c];
                    ++idx;
                } else if (index + 4 < endIndex) {
                    char unicode;
                    builder[idx] = unicode = CharArrayUtils.getUnicode(chars, index);
                    index += 4;
                    ++idx;
                }
            } else {
                builder[idx] = c;
                ++idx;
            }
            if (index >= endIndex - 1) break;
            ++index;
        }
        return new String(builder);
    }

    private static char getUnicode(char[] chars, int index) {
        int d4 = hexValueMap[chars[index + 1]];
        int d3 = hexValueMap[chars[index + 2]];
        int d2 = hexValueMap[chars[index + 3]];
        int d1 = hexValueMap[chars[index + 4]];
        return (char)(d1 + d2 * 16 + d3 * 256 + d4 * 4096);
    }

    private static int calculateLengthAfterEncoding(char[] chars, int startIndex, int endIndex, int length) {
        int index = startIndex;
        int controlCharCount = length;
        while (true) {
            char c;
            if ((c = chars[index]) == '\\' && index < endIndex - 1) {
                if ((c = chars[++index]) != 'u') {
                    --controlCharCount;
                } else if (index + 4 < endIndex) {
                    controlCharCount -= 5;
                    index += 4;
                }
            }
            if (index >= endIndex - 1) break;
            ++index;
        }
        return controlCharCount;
    }

    public static boolean hasEscapeChar(char[] array, int startIndex, int endIndex) {
        for (int index = startIndex; index < endIndex; ++index) {
            char currentChar = array[index];
            if (currentChar != '\\') continue;
            return true;
        }
        return false;
    }

    static {
        CharArrayUtils.controlMap[110] = 10;
        CharArrayUtils.controlMap[98] = 8;
        CharArrayUtils.controlMap[47] = 47;
        CharArrayUtils.controlMap[102] = 12;
        CharArrayUtils.controlMap[114] = 13;
        CharArrayUtils.controlMap[116] = 9;
        CharArrayUtils.controlMap[92] = 92;
        CharArrayUtils.controlMap[34] = 34;
        CharArrayUtils.hexValueMap[48] = 0;
        CharArrayUtils.hexValueMap[49] = 1;
        CharArrayUtils.hexValueMap[50] = 2;
        CharArrayUtils.hexValueMap[51] = 3;
        CharArrayUtils.hexValueMap[52] = 4;
        CharArrayUtils.hexValueMap[53] = 5;
        CharArrayUtils.hexValueMap[54] = 6;
        CharArrayUtils.hexValueMap[55] = 7;
        CharArrayUtils.hexValueMap[56] = 8;
        CharArrayUtils.hexValueMap[57] = 9;
        CharArrayUtils.hexValueMap[97] = 10;
        CharArrayUtils.hexValueMap[98] = 11;
        CharArrayUtils.hexValueMap[99] = 12;
        CharArrayUtils.hexValueMap[100] = 13;
        CharArrayUtils.hexValueMap[101] = 14;
        CharArrayUtils.hexValueMap[102] = 15;
        CharArrayUtils.hexValueMap[65] = 10;
        CharArrayUtils.hexValueMap[66] = 11;
        CharArrayUtils.hexValueMap[67] = 12;
        CharArrayUtils.hexValueMap[68] = 13;
        CharArrayUtils.hexValueMap[69] = 14;
        CharArrayUtils.hexValueMap[70] = 15;
    }
}

