/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node.support;

import io.nats.jparse.node.ArrayNode;
import io.nats.jparse.node.BooleanNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.NullNode;
import io.nats.jparse.node.NumberNode;
import io.nats.jparse.node.ObjectNode;
import io.nats.jparse.node.StringNode;
import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.path.IndexPathNode;
import io.nats.jparse.path.KeyPathNode;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NodeUtils {
    private NodeUtils() {
    }

    public static List<List<Token>> getChildrenTokens(TokenSubList tokens) {
        Token root = tokens.get(0);
        ArrayList<List<Token>> childrenTokens = new ArrayList<List<Token>>(16);
        for (int index = 1; index < tokens.size(); ++index) {
            Token token = tokens.get(index);
            if (token.startIndex > root.endIndex) break;
            if (token.type <= 4) {
                int childCount = tokens.countChildren(index, token);
                int endIndex = index + childCount;
                childrenTokens.add(tokens.subList(index, endIndex));
                index = endIndex - 1;
                continue;
            }
            childrenTokens.add(Collections.singletonList(token));
        }
        return childrenTokens;
    }

    public static Node createNode(List<Token> tokens, CharSource source, boolean objectsKeysCanBeEncoded) {
        NodeType nodeType = NodeType.tokenTypeToElement(tokens.get((int)0).type);
        switch (nodeType) {
            case ARRAY: {
                return new ArrayNode((TokenSubList)tokens, source, objectsKeysCanBeEncoded);
            }
            case INT: {
                return new NumberNode(tokens.get(0), source, NodeType.INT);
            }
            case FLOAT: {
                return new NumberNode(tokens.get(0), source, NodeType.FLOAT);
            }
            case OBJECT: {
                return new ObjectNode((TokenSubList)tokens, source, objectsKeysCanBeEncoded);
            }
            case STRING: {
                return new StringNode(tokens.get(0), source);
            }
            case BOOLEAN: {
                return new BooleanNode(tokens.get(0), source);
            }
            case NULL: {
                return new NullNode(tokens.get(0), source);
            }
            case PATH_INDEX: {
                return new IndexPathNode(tokens.get(0), source);
            }
            case PATH_KEY: {
                return new KeyPathNode(tokens.get(0), source);
            }
        }
        throw new IllegalStateException();
    }

    public static Node createNodeForObject(List<Token> theTokens, CharSource source, boolean objectsKeysCanBeEncoded) {
        Token rootToken = theTokens.get(1);
        List<Token> tokens = theTokens.subList(1, theTokens.size());
        NodeType nodeType = NodeType.tokenTypeToElement(rootToken.type);
        switch (nodeType) {
            case ARRAY: {
                return new ArrayNode((TokenSubList)tokens, source, objectsKeysCanBeEncoded);
            }
            case INT: {
                return new NumberNode(tokens.get(0), source, NodeType.INT);
            }
            case FLOAT: {
                return new NumberNode(tokens.get(0), source, NodeType.FLOAT);
            }
            case OBJECT: {
                return new ObjectNode((TokenSubList)tokens, source, objectsKeysCanBeEncoded);
            }
            case STRING: {
                return new StringNode(tokens.get(0), source);
            }
            case BOOLEAN: {
                return new BooleanNode(tokens.get(0), source);
            }
            case NULL: {
                return new NullNode(tokens.get(0), source);
            }
        }
        throw new IllegalStateException();
    }
}

