/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node.support;

import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.token.Token;
import java.util.AbstractList;
import java.util.List;

public class TokenList
extends AbstractList<Token> {
    private Token[] tokens;
    private int index = 0;

    public TokenList() {
        this.tokens = new Token[32];
    }

    public TokenList(Token[] tokens) {
        this.index = tokens.length;
        this.tokens = tokens;
    }

    @Override
    public void clear() {
        this.index = 0;
    }

    @Override
    public final boolean add(Token token) {
        int length = this.tokens.length;
        if (this.index >= length) {
            Token[] newTokens = new Token[length * 2];
            System.arraycopy(this.tokens, 0, newTokens, 0, length);
            this.tokens = newTokens;
        }
        this.tokens[this.index] = token;
        ++this.index;
        return true;
    }

    @Override
    public final List<Token> subList(int from, int to) {
        return new TokenSubList(this.tokens, from, to);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public final Token set(int index, Token element) {
        this.tokens[index] = element;
        return null;
    }

    @Override
    public Token get(int index) {
        return this.tokens[index];
    }

    @Override
    public int size() {
        return this.index;
    }

    public Token[] getTokens() {
        return this.tokens;
    }

    public void placeHolder() {
        int length = this.tokens.length;
        if (this.index >= length) {
            Token[] newTokens = new Token[length * 2];
            System.arraycopy(this.tokens, 0, newTokens, 0, length);
            this.tokens = newTokens;
        }
        ++this.index;
    }

    public TokenList compactClone() {
        int length = this.index;
        Token[] newTokens = new Token[this.index];
        System.arraycopy(this.tokens, 0, newTokens, 0, length);
        return new TokenList(newTokens);
    }

    public void undoPlaceholder() {
        --this.index;
    }
}

