/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.node.support;

import io.nats.jparse.token.Token;
import java.util.AbstractList;
import java.util.List;

public class TokenSubList
extends AbstractList<Token> {
    private final int size;
    private final Token[] tokens;
    private final int offset;
    private final int endIndex;

    public TokenSubList(Token[] tokens, int offset, int endIndex) {
        this.size = endIndex - offset;
        this.tokens = tokens;
        this.offset = offset;
        this.endIndex = endIndex;
    }

    @Override
    public Token get(int index) {
        return this.tokens[this.offset + index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Token> subList(int startIndex, int endIndex) {
        return new TokenSubList(this.tokens, this.offset + startIndex, this.offset + endIndex);
    }

    public Token[] toArray() {
        Token[] array = new Token[this.size];
        System.arraycopy(this.tokens, this.offset, array, 0, this.size);
        return array;
    }

    public int countChildren(int from, Token rootToken) {
        int count = 0;
        Token[] tokens = this.tokens;
        int length = this.size;
        int offset = this.offset;
        int rootTokenStart = rootToken.startIndex;
        int rootTokenEnd = rootToken.endIndex;
        for (int idx = from; idx < length; ++idx) {
            Token token = tokens[idx + offset];
            if (token.startIndex < rootTokenStart || token.endIndex > rootTokenEnd) break;
            ++count;
        }
        return count;
    }
}

