/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser;

import io.nats.jparse.parser.JsonEventParser;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.parser.event.JsonEventFastParser;
import io.nats.jparse.parser.event.JsonEventStrictParser;
import io.nats.jparse.parser.functable.JsonFuncParser;
import io.nats.jparse.parser.functable.JsonParserFunctions;
import io.nats.jparse.parser.functable.ParseFunction;
import io.nats.jparse.parser.functable.ParsePartFunction;
import io.nats.jparse.parser.indexoverlay.JsonFastParser;
import io.nats.jparse.parser.indexoverlay.JsonStrictParser;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.TokenEventListener;
import java.util.Arrays;

public class JsonParserBuilder {
    private TokenEventListener tokenEventListener;
    private boolean strict = false;
    private boolean objectsKeysCanBeEncoded;
    private boolean allowHashComment;
    private boolean allowSlashSlashComment;
    private boolean allowSlashStarComment;
    private ParseFunction[] funcTable;
    private ParsePartFunction parseKey;
    private ParseFunction defaultFunc;
    private boolean supportNoQuoteKeys;

    public static JsonParserBuilder builder() {
        return new JsonParserBuilder();
    }

    public boolean isSupportNoQuoteKeys() {
        return this.supportNoQuoteKeys;
    }

    public JsonParserBuilder setSupportNoQuoteKeys(boolean supportNoQuoteKeys) {
        this.supportNoQuoteKeys = supportNoQuoteKeys;
        return this;
    }

    public TokenEventListener tokenEventListener() {
        return this.tokenEventListener;
    }

    public JsonParserBuilder setTokenEventListener(TokenEventListener tokenEventListener) {
        this.tokenEventListener = tokenEventListener;
        return this;
    }

    public boolean strict() {
        return this.strict;
    }

    public JsonParserBuilder setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public boolean objectsKeysCanBeEncoded() {
        return this.objectsKeysCanBeEncoded;
    }

    public JsonParserBuilder setObjectsKeysCanBeEncoded(boolean objectsKeysCanBeEncoded) {
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
        return this;
    }

    public boolean isAllowHashComment() {
        return this.allowHashComment;
    }

    public JsonParserBuilder setAllowHashComment(boolean allowHashComment) {
        this.allowHashComment = allowHashComment;
        return this;
    }

    public boolean isAllowSlashSlashComment() {
        return this.allowSlashSlashComment;
    }

    public JsonParserBuilder setAllowSlashSlashComment(boolean allowSlashSlashComment) {
        this.allowSlashSlashComment = allowSlashSlashComment;
        return this;
    }

    public boolean isAllowSlashStarComment() {
        return this.allowSlashStarComment;
    }

    public JsonParserBuilder setAllowSlashStarComment(boolean allowSlashStarComment) {
        this.allowSlashStarComment = allowSlashStarComment;
        return this;
    }

    public ParseFunction[] getFuncTable() {
        if (this.funcTable == null) {
            this.funcTable = new ParseFunction[256];
            Arrays.fill(this.funcTable, this.getDefaultFunc());
        }
        return this.funcTable;
    }

    public JsonParserBuilder setFuncTable(ParseFunction[] funcTable) {
        this.funcTable = funcTable;
        return this;
    }

    public ParsePartFunction getParseKey() {
        if (this.parseKey == null) {
            this.parseKey = this.supportNoQuoteKeys() ? JsonParserFunctions::parseKeyNoQuote : JsonParserFunctions::parseKeyWithEncode;
        }
        return this.parseKey;
    }

    public JsonParserBuilder setParseKey(ParsePartFunction parseKey) {
        this.parseKey = parseKey;
        return this;
    }

    public ParseFunction getDefaultFunc() {
        if (this.defaultFunc == null) {
            this.defaultFunc = JsonParserFunctions.defaultFunc;
        }
        return this.defaultFunc;
    }

    public JsonParserBuilder setDefaultFunc(ParseFunction defaultFunc) {
        this.defaultFunc = defaultFunc;
        return this;
    }

    public boolean supportNoQuoteKeys() {
        return this.supportNoQuoteKeys;
    }

    public JsonParserBuilder setAllowComments(boolean allowComments) {
        this.allowHashComment = allowComments;
        this.allowSlashSlashComment = allowComments;
        this.allowSlashStarComment = allowComments;
        return this;
    }

    public JsonParser build() {
        if (this.strict()) {
            return new JsonStrictParser(this.objectsKeysCanBeEncoded());
        }
        if (this.isSupportNoQuoteKeys() || this.isAllowHashComment() || this.isAllowSlashSlashComment() || this.isAllowSlashStarComment() || this.parseKey != null) {
            ParseFunction[] funcTable = this.getFuncTable();
            funcTable[34] = JsonParserFunctions::parseString;
            funcTable[110] = JsonParserFunctions::parseNull;
            funcTable[116] = JsonParserFunctions::parseTrue;
            funcTable[102] = JsonParserFunctions::parseFalse;
            for (int i = 48; i < 58; ++i) {
                funcTable[i] = JsonParserFunctions::parseNumber;
            }
            funcTable[45] = JsonParserFunctions::parseNumber;
            funcTable[43] = JsonParserFunctions::parseNumber;
            if (this.isAllowHashComment()) {
                funcTable[35] = (source, tokens) -> source.findChar('\n');
            }
            if (this.isSupportNoQuoteKeys() && this.getParseKey() == null) {
                this.setParseKey(JsonParserFunctions::parseKeyNoQuote);
            }
            if (this.isAllowSlashStarComment() || this.isAllowSlashSlashComment()) {
                funcTable[47] = (source, tokens) -> {
                    int next = source.next();
                    if (next == 47) {
                        source.findChar('\n');
                    } else if (next == 42) {
                        block4: while (source.findChar('*')) {
                            switch (source.next()) {
                                case 47: {
                                    break block4;
                                }
                                case 3: {
                                    throw new UnexpectedCharacterException("Comment parse", "End of stream", source);
                                }
                                default: {
                                    continue block4;
                                }
                            }
                        }
                    }
                };
            }
            return new JsonFuncParser(this.objectsKeysCanBeEncoded(), Arrays.copyOf(funcTable, funcTable.length), this.getDefaultFunc(), this.getParseKey());
        }
        return new JsonFastParser(this.objectsKeysCanBeEncoded());
    }

    public JsonEventParser buildEventParser() {
        if (this.strict()) {
            return new JsonEventStrictParser(this.objectsKeysCanBeEncoded(), this.tokenEventListener());
        }
        return new JsonEventFastParser(this.objectsKeysCanBeEncoded(), this.tokenEventListener());
    }

    public JsonParserBuilder cloneBuilder() {
        return new JsonParserBuilder().setStrict(this.strict()).setTokenEventListener(this.tokenEventListener()).setObjectsKeysCanBeEncoded(this.objectsKeysCanBeEncoded());
    }
}

