/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser.event;

import io.nats.jparse.node.RootNode;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.parser.JsonEventParser;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.Token;
import io.nats.jparse.token.TokenEventListener;
import io.nats.jparse.token.TokenTypes;
import java.util.List;

public abstract class JsonEventAbstractParser
implements JsonEventParser,
JsonParser {
    protected final boolean objectsKeysCanBeEncoded;
    final TokenEventListener arrayItemListener = new TokenEventListener(){

        @Override
        public void start(int tokenId, int index, CharSource source) {
        }

        @Override
        public void end(int tokenId, int index, CharSource source) {
        }
    };
    final TokenEventListener exceptionListener = new TokenEventListener(){

        @Override
        public void start(int tokenId, int index, CharSource source) {
            throw new UnexpectedCharacterException("while doing event parsing", "Unknown token id " + tokenId, source);
        }

        @Override
        public void end(int tokenId, int index, CharSource source) {
        }
    };
    private final TokenEventListener tokenEventListener;
    private final TokenEventListener stringListener = new ScalarListener(7);
    private final TokenEventListener floatListener = new ScalarListener(6);
    private final TokenEventListener intListener = new ScalarListener(5);
    private final TokenEventListener booleanListener = new ScalarListener(8);
    private final TokenEventListener nullListener = new ScalarListener(9);
    final TokenEventListener base = new TokenEventListener(){
        private int stackIndex = -1;
        private TokenEventListener[] stack = new TokenEventListener[8];

        @Override
        public void start(int tokenId, int index, CharSource source) {
            TokenEventListener listener;
            switch (tokenId) {
                case 0: {
                    listener = new ComplexListener(0);
                    break;
                }
                case 3: {
                    listener = new ComplexListener(3);
                    break;
                }
                case 4: {
                    listener = JsonEventAbstractParser.this.arrayItemListener;
                    break;
                }
                case 1: {
                    listener = new ComplexListener(1);
                    break;
                }
                case 2: {
                    listener = new ComplexListener(2);
                    break;
                }
                case 7: {
                    listener = JsonEventAbstractParser.this.stringListener;
                    break;
                }
                case 6: {
                    listener = JsonEventAbstractParser.this.floatListener;
                    break;
                }
                case 5: {
                    listener = JsonEventAbstractParser.this.intListener;
                    break;
                }
                case 8: {
                    listener = JsonEventAbstractParser.this.booleanListener;
                    break;
                }
                case 9: {
                    listener = JsonEventAbstractParser.this.nullListener;
                    break;
                }
                default: {
                    listener = JsonEventAbstractParser.this.exceptionListener;
                }
            }
            listener.start(tokenId, index, source);
            ++this.stackIndex;
            if (this.stackIndex >= this.stack.length) {
                TokenEventListener[] stackNew = new TokenEventListener[this.stack.length * 2];
                System.arraycopy(this.stack, 0, stackNew, 0, this.stack.length);
                this.stack = stackNew;
            }
            this.stack[this.stackIndex] = listener;
        }

        @Override
        public void end(int tokenId, int index, CharSource source) {
            this.stack[this.stackIndex].end(tokenId, index, source);
            this.stack[this.stackIndex] = null;
            --this.stackIndex;
        }
    };
    private TokenList tokenList;

    public JsonEventAbstractParser(boolean objectsKeysCanBeEncoded, TokenEventListener tokenEventListener) {
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
        this.tokenEventListener = tokenEventListener;
    }

    @Override
    public List<Token> scan(CharSource source) {
        this.tokenList = new TokenList();
        this.parseWithEvents(source, this.base);
        return this.tokenList;
    }

    @Override
    public TokenEventListener tokenEvents() {
        return this.tokenEventListener;
    }

    @Override
    public RootNode parse(CharSource source) {
        return new RootNode((TokenList)this.scan(source), source, this.objectsKeysCanBeEncoded);
    }

    class ComplexListener
    implements TokenEventListener {
        final int tokenType;
        int startIndex;
        int tokenListIndex;

        ComplexListener(int tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public void start(int tokenId, int index, CharSource source) {
            this.startIndex = index;
            this.tokenListIndex = JsonEventAbstractParser.this.tokenList.getIndex();
            JsonEventAbstractParser.this.tokenList.placeHolder();
        }

        @Override
        public void end(int tokenId, int index, CharSource source) {
            JsonEventAbstractParser.this.tokenList.set(this.tokenListIndex, new Token(this.startIndex, index, this.tokenType));
        }

        public String toString() {
            return "ComplexListener{tokenType=" + TokenTypes.getTypeName(this.tokenType) + ", startIndex=" + this.startIndex + ", tokenListIndex=" + this.tokenListIndex + '}';
        }
    }

    class ScalarListener
    implements TokenEventListener {
        final int tokenType;
        int startIndex;

        ScalarListener(int tokenType) {
            this.tokenType = tokenType;
        }

        @Override
        public void start(int tokenId, int index, CharSource source) {
            this.startIndex = index;
        }

        @Override
        public void end(int tokenId, int index, CharSource source) {
            JsonEventAbstractParser.this.tokenList.add(new Token(this.startIndex, index, this.tokenType));
        }

        public String toString() {
            return "ScalarListener{tokenType=" + TokenTypes.getTypeName(this.tokenType) + ", startIndex=" + this.startIndex + '}';
        }
    }
}

