/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser.event;

import io.nats.jparse.node.support.NumberParseResult;
import io.nats.jparse.parser.event.JsonEventAbstractParser;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.TokenEventListener;

public class JsonEventStrictParser
extends JsonEventAbstractParser {
    private int nestLevel;

    public JsonEventStrictParser(boolean objectsKeysCanBeEncoded, TokenEventListener tokenEventListener) {
        super(objectsKeysCanBeEncoded, tokenEventListener);
    }

    @Override
    public void parseWithEvents(CharSource source, TokenEventListener event) {
        int ch = source.nextSkipWhiteSpace();
        switch (ch) {
            case 123: {
                this.parseObject(source, event);
                break;
            }
            case 91: {
                this.parseArray(source, event);
                break;
            }
            case 116: {
                this.parseTrue(source, event);
                break;
            }
            case 102: {
                this.parseFalse(source, event);
                break;
            }
            case 110: {
                this.parseNull(source, event);
                break;
            }
            case 34: {
                this.parseString(source, event);
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.parseNumber(source, event);
                break;
            }
            default: {
                throw new UnexpectedCharacterException("Scanning JSON", "Unexpected character", source, (int)((char)ch));
            }
        }
        source.checkForJunk();
    }

    private void parseFalse(CharSource source, TokenEventListener event) {
        event.start(8, source.getIndex(), source);
        event.end(8, source.findFalseEnd(), source);
    }

    private void parseTrue(CharSource source, TokenEventListener event) {
        event.start(8, source.getIndex(), source);
        event.end(8, source.findTrueEnd(), source);
    }

    private void parseNull(CharSource source, TokenEventListener event) {
        event.start(9, source.getIndex(), source);
        event.end(9, source.findNullEnd(), source);
    }

    private void parseArray(CharSource source, TokenEventListener event) {
        this.levelCheck(source);
        event.start(3, source.getIndex(), source);
        boolean done = false;
        while (!done) {
            done = this.parseArrayItem(source, event);
            if (done) continue;
            done = source.findCommaOrEndForArray();
        }
        event.end(3, source.getIndex(), source);
    }

    private boolean parseArrayItem(CharSource source, TokenEventListener event) {
        char startChar = source.getCurrentChar();
        int ch = source.nextSkipWhiteSpace();
        switch (ch) {
            case 123: {
                event.start(4, source.getIndex(), source);
                this.parseObject(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 91: {
                event.start(4, source.getIndex(), source);
                this.parseArray(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 116: {
                event.start(4, source.getIndex(), source);
                this.parseTrue(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 102: {
                event.start(4, source.getIndex(), source);
                this.parseFalse(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 110: {
                event.start(4, source.getIndex(), source);
                this.parseNull(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 34: {
                event.start(4, source.getIndex(), source);
                this.parseString(source, event);
                event.end(4, source.getIndex(), source);
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                event.start(4, source.getIndex(), source);
                this.parseNumber(source, event);
                event.end(4, source.getIndex(), source);
                if (source.getCurrentChar() != ']' && source.getCurrentChar() != ',' || source.getCurrentChar() != ']') break;
                source.next();
                return true;
            }
            case 93: {
                if (startChar == ',') {
                    throw new UnexpectedCharacterException("Parsing Array Item", "Trailing comma", source, (int)((char)ch));
                }
                source.next();
                return true;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing Array Item", "Unexpected character", source, (int)((char)ch));
            }
        }
        return false;
    }

    private void parseNumber(CharSource source, TokenEventListener event) {
        int startIndex = source.getIndex();
        NumberParseResult numberParse = source.findEndOfNumber();
        int tokenType = numberParse.wasFloat() ? 6 : 5;
        event.start(tokenType, startIndex, source);
        event.end(tokenType, numberParse.endIndex(), source);
    }

    private boolean parseKey(CharSource source, TokenEventListener event) {
        char startChar = source.getCurrentChar();
        int ch = source.nextSkipWhiteSpace();
        event.start(1, source.getIndex(), source);
        boolean found = false;
        switch (ch) {
            case 34: {
                int strStartIndex = source.getIndex();
                event.start(7, strStartIndex + 1, source);
                int strEndIndex = this.objectsKeysCanBeEncoded ? source.findEndOfEncodedString() : source.findEndString();
                found = true;
                event.end(7, strEndIndex, source);
                break;
            }
            case 125: {
                if (startChar == ',') {
                    throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
                }
                return true;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
            }
        }
        boolean done = source.findObjectEndOrAttributeSep();
        if (!done && found) {
            event.end(1, source.getIndex(), source);
        } else if (found && done) {
            throw new UnexpectedCharacterException("Parsing key", "Not found", source);
        }
        return done;
    }

    private boolean parseValue(CharSource source, TokenEventListener event) {
        int ch = source.nextSkipWhiteSpace();
        event.start(2, source.getIndex(), source);
        switch (ch) {
            case 123: {
                this.parseObject(source, event);
                break;
            }
            case 91: {
                this.parseArray(source, event);
                break;
            }
            case 116: {
                this.parseTrue(source, event);
                break;
            }
            case 102: {
                this.parseFalse(source, event);
                break;
            }
            case 110: {
                this.parseNull(source, event);
                break;
            }
            case 34: {
                this.parseString(source, event);
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.parseNumber(source, event);
                break;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing Value", "Unexpected character", source, ch);
            }
        }
        source.skipWhiteSpace();
        switch (source.getCurrentChar()) {
            case '}': {
                event.end(2, source.getIndex(), source);
                return true;
            }
            case ',': {
                event.end(2, source.getIndex(), source);
                return false;
            }
        }
        throw new UnexpectedCharacterException("Parsing Value", "Unexpected character", source, (int)source.getCurrentChar());
    }

    private void parseString(CharSource source, TokenEventListener event) {
        event.start(7, source.getIndex() + 1, source);
        event.end(7, source.findEndOfEncodedString(), source);
    }

    private void parseObject(CharSource source, TokenEventListener event) {
        this.levelCheck(source);
        event.start(0, source.getIndex(), source);
        boolean done = false;
        while (!done) {
            done = this.parseKey(source, event);
            if (done) continue;
            done = this.parseValue(source, event);
        }
        if (source.getCurrentChar() != '}') {
            throw new UnexpectedCharacterException("Parsing Object", "Unexpected character", source, (int)source.getCurrentCharSafe());
        }
        source.next();
        event.end(0, source.getIndex(), source);
    }

    private void levelCheck(CharSource source) {
        ++this.nestLevel;
        if (this.nestLevel > 2000) {
            throw new UnexpectedCharacterException("Next level violation", "Too many levels " + this.nestLevel, source);
        }
    }
}

