/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser.functable;

import io.nats.jparse.node.RootNode;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.parser.functable.JsonParserFunctions;
import io.nats.jparse.parser.functable.ParseFunction;
import io.nats.jparse.parser.functable.ParsePartFunction;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.Token;
import java.util.List;

public class JsonFuncParser
implements JsonParser {
    private final boolean objectsKeysCanBeEncoded;
    private final ParseFunction[] funcTable;
    private final ParsePartFunction parseKey;
    private final ParseFunction defaultFunc;

    public JsonFuncParser(boolean objectsKeysCanBeEncoded, ParseFunction[] funcTable, ParseFunction defaultFunc, ParsePartFunction parseKey) {
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
        this.funcTable = funcTable;
        ParseFunction parseFunction = this.defaultFunc = defaultFunc == null ? JsonParserFunctions.defaultFunc : defaultFunc;
        this.parseKey = parseKey == null ? (objectsKeysCanBeEncoded ? JsonParserFunctions::parseKeyWithEncode : JsonParserFunctions::parseKeyNoEncode) : parseKey;
        funcTable[123] = this::parseObject;
        funcTable[91] = this::parseArray;
    }

    @Override
    public List<Token> scan(CharSource source) {
        return this.scan(source, new TokenList());
    }

    @Override
    public RootNode parse(CharSource source) {
        return new RootNode((TokenList)this.scan(source), source, this.objectsKeysCanBeEncoded);
    }

    private List<Token> scan(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        this.doParse(source, tokens, ch);
        return tokens;
    }

    private void doParse(CharSource source, TokenList tokens, int ch) {
        if (ch < 256) {
            this.funcTable[ch].parse(source, tokens);
        } else {
            this.defaultFunc.parse(source, tokens);
        }
    }

    private void parseArray(CharSource source, TokenList tokens) {
        int startSourceIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean done = false;
        while (!done) {
            done = this.parseArrayItem(source, tokens);
        }
        Token arrayToken = new Token(startSourceIndex, source.getIndex(), 3);
        tokens.set(tokenListIndex, arrayToken);
    }

    private boolean parseArrayItem(CharSource source, TokenList tokens) {
        char ch = (char)source.nextSkipWhiteSpace();
        if (ch != '\u0003') {
            switch (ch) {
                case ']': {
                    source.next();
                    return true;
                }
                case ',': {
                    source.next();
                    return false;
                }
            }
            this.doParse(source, tokens, ch);
        }
        if (source.getCurrentChar() == ']') {
            source.next();
            return true;
        }
        return false;
    }

    private boolean parseValue(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        this.doParse(source, tokens, ch);
        ch = source.skipWhiteSpace();
        switch (ch) {
            case 125: {
                if (source.getIndex() == tokenListIndex) {
                    throw new UnexpectedCharacterException("Parsing Value", "Key separator before value", source);
                }
                tokens.set(tokenListIndex, new Token(startIndex, source.getIndex(), 2));
                return true;
            }
            case 44: {
                if (source.getIndex() == tokenListIndex) {
                    throw new UnexpectedCharacterException("Parsing Value", "Key separator before value", source);
                }
                tokens.set(tokenListIndex, new Token(startIndex, source.getIndex(), 2));
                return false;
            }
        }
        throw new UnexpectedCharacterException("Parsing Value", "Unexpected character", source, (int)source.getCurrentChar());
    }

    private void parseObject(CharSource source, TokenList tokens) {
        int startSourceIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean done = false;
        while (!done) {
            done = this.parseKey.parse(source, tokens);
            if (done) continue;
            done = this.parseValue(source, tokens);
        }
        source.next();
        tokens.set(tokenListIndex, new Token(startSourceIndex, source.getIndex(), 0));
    }
}

