/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser.functable;

import io.nats.jparse.node.support.NumberParseResult;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.parser.functable.ParseFunction;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.Token;

public class JsonParserFunctions {
    public static ParseFunction defaultFunc = (source, tokens) -> {
        throw new UnexpectedCharacterException("Scanning JSON", "Unexpected character", source);
    };

    private JsonParserFunctions() {
    }

    public static void parseFalse(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findFalseEnd();
        tokens.add(new Token(start, end, 8));
    }

    public static void parseTrue(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findTrueEnd();
        tokens.add(new Token(start, end, 8));
    }

    public static void parseNull(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findNullEnd();
        tokens.add(new Token(start, end, 9));
    }

    public static void parseNumber(CharSource source, TokenList tokens) {
        int startIndex = source.getIndex();
        NumberParseResult numberParse = source.findEndOfNumberFast();
        tokens.add(new Token(startIndex, numberParse.endIndex(), numberParse.wasFloat() ? 6 : 5));
    }

    public static boolean parseKeyNoQuote(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex() - 1;
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean found = false;
        switch (ch) {
            case 34: {
                int strStartIndex = startIndex + 1;
                int strEndIndex = source.findEndOfEncodedString();
                tokens.add(new Token(strStartIndex + 1, strEndIndex, 7));
                found = true;
                break;
            }
            case 125: {
                tokens.undoPlaceholder();
                return true;
            }
            default: {
                if (Character.isAlphabetic(ch)) {
                    int start = source.getIndex();
                    int end = source.findAttributeEnd();
                    tokens.add(new Token(start, end, 7));
                    found = true;
                    break;
                }
                throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
            }
        }
        boolean done = source.findObjectEndOrAttributeSep();
        if (!done && found) {
            tokens.set(tokenListIndex, new Token(startIndex + 1, source.getIndex(), 1));
        } else if (found && done) {
            throw new UnexpectedCharacterException("Parsing key", "Not found", source);
        }
        return done;
    }

    public static boolean parseKeyWithEncode(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex() - 1;
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean found = false;
        switch (ch) {
            case 34: {
                int strStartIndex = startIndex + 1;
                int strEndIndex = source.findEndOfEncodedString();
                tokens.add(new Token(strStartIndex + 1, strEndIndex, 7));
                found = true;
                break;
            }
            case 125: {
                tokens.undoPlaceholder();
                return true;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
            }
        }
        boolean done = source.findObjectEndOrAttributeSep();
        if (!done && found) {
            tokens.set(tokenListIndex, new Token(startIndex + 1, source.getIndex(), 1));
        } else if (found && done) {
            throw new UnexpectedCharacterException("Parsing key", "Not found", source);
        }
        return done;
    }

    public static boolean parseKeyNoEncode(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex() - 1;
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean found = false;
        switch (ch) {
            case 34: {
                int strStartIndex = startIndex + 1;
                int strEndIndex = source.findEndString();
                tokens.add(new Token(strStartIndex + 1, strEndIndex, 7));
                found = true;
                break;
            }
            case 125: {
                tokens.undoPlaceholder();
                return true;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
            }
        }
        boolean done = source.findObjectEndOrAttributeSep();
        if (!done && found) {
            tokens.set(tokenListIndex, new Token(startIndex + 1, source.getIndex(), 1));
        } else if (found && done) {
            throw new UnexpectedCharacterException("Parsing key", "Not found", source);
        }
        return done;
    }

    public static void parseString(CharSource source, TokenList tokens) {
        int startIndex = source.getIndex();
        int endIndex = source.findEndOfEncodedStringFast();
        tokens.add(new Token(startIndex + 1, endIndex, 7));
    }
}

