/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.parser.indexoverlay;

import io.nats.jparse.node.RootNode;
import io.nats.jparse.node.support.NumberParseResult;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import io.nats.jparse.token.Token;
import java.util.List;

public class JsonFastParser
implements JsonParser {
    private final boolean objectsKeysCanBeEncoded;

    public JsonFastParser(boolean objectsKeysCanBeEncoded) {
        this.objectsKeysCanBeEncoded = objectsKeysCanBeEncoded;
    }

    @Override
    public List<Token> scan(CharSource source) {
        return this.scan(source, new TokenList());
    }

    @Override
    public RootNode parse(CharSource source) {
        return new RootNode((TokenList)this.scan(source), source, this.objectsKeysCanBeEncoded);
    }

    private List<Token> scan(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        switch (ch) {
            case 123: {
                this.parseObject(source, tokens);
                break;
            }
            case 91: {
                this.parseArray(source, tokens);
                break;
            }
            case 116: {
                this.parseTrue(source, tokens);
                break;
            }
            case 102: {
                this.parseFalse(source, tokens);
                break;
            }
            case 110: {
                this.parseNull(source, tokens);
                break;
            }
            case 34: {
                this.parseString(source, tokens);
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.parseNumber(source, tokens);
                break;
            }
            default: {
                throw new UnexpectedCharacterException("Scanning JSON", "Unexpected character", source, (int)((char)ch));
            }
        }
        return tokens;
    }

    private void parseFalse(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findFalseEnd();
        tokens.add(new Token(start, end, 8));
    }

    private void parseTrue(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findTrueEnd();
        tokens.add(new Token(start, end, 8));
    }

    private void parseNull(CharSource source, TokenList tokens) {
        int start = source.getIndex();
        int end = source.findNullEnd();
        tokens.add(new Token(start, end, 9));
    }

    private void parseArray(CharSource source, TokenList tokens) {
        int startSourceIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean done = false;
        while (!done) {
            done = this.parseArrayItem(source, tokens);
        }
        Token arrayToken = new Token(startSourceIndex, source.getIndex(), 3);
        tokens.set(tokenListIndex, arrayToken);
    }

    private boolean parseArrayItem(CharSource source, TokenList tokens) {
        char ch = (char)source.nextSkipWhiteSpace();
        if (ch != '\u0003') {
            switch (ch) {
                case '{': {
                    this.parseObject(source, tokens);
                    break;
                }
                case '[': {
                    this.parseArray(source, tokens);
                    break;
                }
                case 't': {
                    this.parseTrue(source, tokens);
                    break;
                }
                case 'f': {
                    this.parseFalse(source, tokens);
                    break;
                }
                case 'n': {
                    this.parseNull(source, tokens);
                    break;
                }
                case '\"': {
                    this.parseString(source, tokens);
                    break;
                }
                case '+': 
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.parseNumber(source, tokens);
                    break;
                }
                case ']': {
                    source.next();
                    return true;
                }
                case ',': {
                    source.next();
                    return false;
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing Array Item", "Unexpected character", source, (int)ch);
                }
            }
        }
        if (source.getCurrentChar() == ']') {
            source.next();
            return true;
        }
        return false;
    }

    private void parseNumber(CharSource source, TokenList tokens) {
        int startIndex = source.getIndex();
        NumberParseResult numberParse = source.findEndOfNumberFast();
        tokens.add(new Token(startIndex, numberParse.endIndex(), numberParse.wasFloat() ? 6 : 5));
    }

    private boolean parseKey(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex() - 1;
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean found = false;
        switch (ch) {
            case 34: {
                int strStartIndex = startIndex + 1;
                int strEndIndex = this.objectsKeysCanBeEncoded ? source.findEndOfEncodedString() : source.findEndString();
                tokens.add(new Token(strStartIndex + 1, strEndIndex, 7));
                found = true;
                break;
            }
            case 125: {
                tokens.undoPlaceholder();
                return true;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing key", "Unexpected character found", source);
            }
        }
        boolean done = source.findObjectEndOrAttributeSep();
        if (!done && found) {
            tokens.set(tokenListIndex, new Token(startIndex + 1, source.getIndex(), 1));
        } else if (found && done) {
            throw new UnexpectedCharacterException("Parsing key", "Not found", source);
        }
        return done;
    }

    private boolean parseValue(CharSource source, TokenList tokens) {
        int ch = source.nextSkipWhiteSpace();
        int startIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        switch (ch) {
            case 123: {
                this.parseObject(source, tokens);
                break;
            }
            case 91: {
                this.parseArray(source, tokens);
                break;
            }
            case 116: {
                this.parseTrue(source, tokens);
                break;
            }
            case 102: {
                this.parseFalse(source, tokens);
                break;
            }
            case 110: {
                this.parseNull(source, tokens);
                break;
            }
            case 34: {
                this.parseString(source, tokens);
                break;
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.parseNumber(source, tokens);
                break;
            }
            default: {
                throw new UnexpectedCharacterException("Parsing Value", "Unexpected character", source, ch);
            }
        }
        ch = source.skipWhiteSpace();
        switch (ch) {
            case 125: {
                if (source.getIndex() == tokenListIndex) {
                    throw new UnexpectedCharacterException("Parsing Value", "Key separator before value", source);
                }
                tokens.set(tokenListIndex, new Token(startIndex, source.getIndex(), 2));
                return true;
            }
            case 44: {
                if (source.getIndex() == tokenListIndex) {
                    throw new UnexpectedCharacterException("Parsing Value", "Key separator before value", source);
                }
                tokens.set(tokenListIndex, new Token(startIndex, source.getIndex(), 2));
                return false;
            }
        }
        throw new UnexpectedCharacterException("Parsing Value", "Unexpected character", source, (int)source.getCurrentChar());
    }

    private void parseString(CharSource source, TokenList tokens) {
        int startIndex = source.getIndex();
        int endIndex = source.findEndOfEncodedStringFast();
        tokens.add(new Token(startIndex + 1, endIndex, 7));
    }

    private void parseObject(CharSource source, TokenList tokens) {
        int startSourceIndex = source.getIndex();
        int tokenListIndex = tokens.getIndex();
        tokens.placeHolder();
        boolean done = false;
        while (!done) {
            done = this.parseKey(source, tokens);
            if (done) continue;
            done = this.parseValue(source, tokens);
        }
        source.next();
        tokens.set(tokenListIndex, new Token(startSourceIndex, source.getIndex(), 0));
    }
}

