/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.path;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.node.support.CharSequenceUtils;
import io.nats.jparse.path.PathElement;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.Collections;
import java.util.List;

public class IndexPathNode
extends Number
implements ScalarNode,
CharSequence,
PathElement {
    private final Token token;
    private final CharSource source;
    private boolean hashCodeSet;
    private int hashCode;

    public IndexPathNode(Token token, CharSource source) {
        this.token = token;
        this.source = source;
    }

    @Override
    public int intValue() {
        return this.source.getInt(this.token.startIndex, this.token.endIndex);
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    @Override
    public float floatValue() {
        return this.intValue();
    }

    @Override
    public double doubleValue() {
        return this.intValue();
    }

    @Override
    public NodeType type() {
        return NodeType.PATH_INDEX;
    }

    @Override
    public Object value() {
        return this.intValue();
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.token);
    }

    @Override
    public Token rootElementToken() {
        return this.token;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            return CharSequenceUtils.equals(this, other);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = CharSequenceUtils.hashCode(this);
        this.hashCodeSet = true;
        return this.hashCode;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    @Override
    public boolean isKey() {
        return false;
    }
}

