/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.path;

import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.ScalarNode;
import io.nats.jparse.path.PathElement;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.Collections;
import java.util.List;

public class KeyPathNode
implements ScalarNode,
PathElement {
    private final Token rootElementToken;
    private final CharSource charSource;

    public KeyPathNode(Token token, CharSource charSource) {
        this.rootElementToken = token;
        this.charSource = charSource;
    }

    @Override
    public NodeType type() {
        return NodeType.PATH_KEY;
    }

    @Override
    public List<Token> tokens() {
        return Collections.singletonList(this.rootElementToken);
    }

    @Override
    public Token rootElementToken() {
        return this.rootElementToken;
    }

    @Override
    public CharSource charSource() {
        return this.charSource;
    }

    @Override
    public Object value() {
        return this.toString();
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public boolean isKey() {
        return true;
    }

    @Override
    public String toString() {
        return this.originalString();
    }

    public CharSequence toCharSequence() {
        return this.originalCharSequence();
    }
}

