/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.path;

import io.nats.jparse.node.CollectionNode;
import io.nats.jparse.node.Node;
import io.nats.jparse.node.NodeType;
import io.nats.jparse.node.support.NodeUtils;
import io.nats.jparse.node.support.TokenSubList;
import io.nats.jparse.path.IndexPathNode;
import io.nats.jparse.path.KeyPathNode;
import io.nats.jparse.path.PathElement;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PathNode
extends AbstractList<PathElement>
implements CollectionNode {
    private final TokenSubList tokens;
    private final CharSource source;
    private final Token rootToken;
    private int hashCode;
    private List<List<Token>> childrenTokens;
    private Node[] elements;
    private boolean hashCodeSet;

    public PathNode(TokenSubList tokens, CharSource source) {
        this.tokens = tokens;
        this.rootToken = tokens.get(0);
        this.source = source;
    }

    @Override
    public List<List<Token>> childrenTokens() {
        if (this.childrenTokens == null) {
            this.childrenTokens = Arrays.stream(this.tokens.toArray()).map(Collections::singletonList).collect(Collectors.toList());
        }
        return this.childrenTokens;
    }

    Node[] elements() {
        if (this.elements == null) {
            this.elements = new Node[this.tokens.size()];
        }
        return this.elements;
    }

    @Override
    public Node getNode(Object key) {
        return this.getNodeAt(Integer.valueOf((String)key));
    }

    public Node getNodeAt(int index) {
        Node element = this.elements()[index];
        if (element == null) {
            List<Token> tokens = Collections.singletonList(this.tokens.get(index));
            this.elements()[index] = NodeUtils.createNode(tokens, this.source, false);
        }
        return this.elements()[index];
    }

    public int getPathIndexValue(int index) {
        return this.getIndexNode(index).intValue();
    }

    public String getPathKeyValue(int index) {
        return this.getKeyNode(index).toString();
    }

    public KeyPathNode getKeyNode(int index) {
        return (KeyPathNode)this.getNodeAt(index);
    }

    public IndexPathNode getIndexNode(int index) {
        return (IndexPathNode)this.getNodeAt(index);
    }

    @Override
    public int length() {
        return this.elements().length;
    }

    @Override
    public NodeType type() {
        return NodeType.PATH;
    }

    @Override
    public List<Token> tokens() {
        return this.tokens;
    }

    @Override
    public Token rootElementToken() {
        return this.rootToken;
    }

    @Override
    public CharSource charSource() {
        return this.source;
    }

    @Override
    public PathElement get(int index) {
        return (PathElement)this.getNodeAt(index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathNode)) {
            return false;
        }
        PathNode other = (PathNode)o;
        if (this.tokens.size() != other.tokens.size()) {
            return false;
        }
        for (int index = 0; index < this.tokens.size(); ++index) {
            String otherStr;
            String thisStr;
            Token thisValue = this.tokens.get(index);
            Token otherValue = other.tokens.get(index);
            if (otherValue == null && thisValue == null || (thisStr = thisValue.asString(this.source)).equals(otherStr = otherValue.asString(other.source))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCodeSet) {
            return this.hashCode;
        }
        this.hashCode = Objects.hash(this.tokens.stream().map(tok -> tok.asString(this.source)).collect(Collectors.toList()));
        this.hashCodeSet = true;
        return this.hashCode;
    }

    @Override
    public int size() {
        return this.tokens().size();
    }

    @Override
    public Iterator<PathElement> iterator() {
        return new Iterator<PathElement>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < PathNode.this.tokens().size();
            }

            @Override
            public PathElement next() {
                return (PathElement)PathNode.this.getNodeAt(this.index++);
            }
        };
    }
}

