/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.path;

import io.nats.jparse.node.RootNode;
import io.nats.jparse.node.support.TokenList;
import io.nats.jparse.parser.JsonParser;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.Token;
import java.util.List;

public class PathParser
implements JsonParser {
    @Override
    public List<Token> scan(CharSource source) {
        return this.scan(source, new TokenList());
    }

    @Override
    public RootNode parse(CharSource source) {
        return new RootNode((TokenList)this.scan(source), source, true);
    }

    private List<Token> scan(CharSource source, TokenList tokens) {
        char ch = ' ';
        block6: while (true) {
            ch = (char)source.next();
            switch (ch) {
                case '[': {
                    this.parseIndexOrKey(source, (char)source.next(), tokens);
                    continue block6;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.parseKeyName(source, ch, tokens);
                    continue block6;
                }
                case '.': {
                    this.parseKeyName(source, (char)source.next(), tokens);
                    continue block6;
                }
                case '\u0003': {
                    break block6;
                }
                default: {
                    throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
                }
            }
            break;
        }
        return tokens;
    }

    private void parseIndexOrKey(CharSource source, char ch, TokenList tokens) {
        int startIndex = source.getIndex();
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.parseIndex(source, startIndex, tokens, ch);
                break;
            }
            case '\'': {
                this.parseKeyWithQuotes(source, startIndex + 1, tokens, ch);
                break;
            }
            case '\u0003': {
                throw new IllegalStateException("reached end");
            }
            default: {
                throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseKeyWithQuotes(CharSource source, int startIndex, TokenList tokens, char ch) {
        block5: while (true) {
            ch = (char)source.next();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block5;
                }
                case '\'': {
                    break block5;
                }
                case '\u0003': {
                    throw new IllegalStateException("reached end");
                }
                default: {
                    if (ch <= '\u0014' || ch >= '\u007f') throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
                    continue block5;
                }
            }
            break;
        }
        int endIndex = source.getIndex();
        int i = source.nextSkipWhiteSpace();
        if (i != 93) {
            throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
        }
        tokens.add(new Token(startIndex, endIndex, 10));
    }

    private void parseKeyName(CharSource source, char ch, TokenList tokens) {
        int startIndex = source.getIndex();
        block6: while (true) {
            ch = (char)source.next();
            switch (ch) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block6;
                }
                case '\u0003': {
                    break block6;
                }
                case '.': {
                    break block6;
                }
                case '[': {
                    int endIndex = source.getIndex();
                    tokens.add(new Token(startIndex, endIndex, 10));
                    this.parseIndexOrKey(source, (char)source.next(), tokens);
                    return;
                }
                default: {
                    throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
                }
            }
            break;
        }
        int endIndex = source.getIndex();
        tokens.add(new Token(startIndex, endIndex, 10));
    }

    private void parseIndex(CharSource source, int startIndex, TokenList tokens, char ch) {
        block5: while (true) {
            ch = (char)source.next();
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                case ']': {
                    break block5;
                }
                case '\u0003': {
                    throw new IllegalStateException("reached end");
                }
                default: {
                    throw new IllegalStateException("Unable to understand char " + ch + " index " + source.getIndex());
                }
            }
            break;
        }
        int endIndex = source.getIndex();
        tokens.add(new Token(startIndex, endIndex, 11));
    }
}

