/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source;

import io.nats.jparse.node.support.CharArrayUtils;
import io.nats.jparse.node.support.NumberParseResult;
import io.nats.jparse.node.support.ParseConstants;
import io.nats.jparse.source.CharSource;
import io.nats.jparse.source.support.CharArraySegment;
import io.nats.jparse.source.support.ParseDouble;
import io.nats.jparse.source.support.ParseFloat;
import io.nats.jparse.source.support.UnexpectedCharacterException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CharArrayCharSource
implements CharSource,
ParseConstants {
    private static final char[] MIN_INT_CHARS = MIN_INT_STR.toCharArray();
    private static final char[] MAX_INT_CHARS = MAX_INT_STR.toCharArray();
    private final char[] data;
    private int index = -1;

    public CharArrayCharSource(char[] chars) {
        this.data = chars;
    }

    public CharArrayCharSource(String str) {
        this.data = str.toCharArray();
    }

    public static String debugCharDescription(int c) {
        String charString = c == 32 ? "[SPACE]" : (c == 9 ? "[TAB]" : (c == 10 ? "[NEWLINE]" : (c == 3 ? "ETX" : "'" + (char)c + "'")));
        charString = charString + " with an int value of " + c;
        return charString;
    }

    @Override
    public int next() {
        if (this.index + 1 >= this.data.length) {
            this.index = this.data.length;
            return 3;
        }
        return this.data[++this.index];
    }

    @Override
    public void checkForJunk() {
        char[] data = this.data;
        int length = data.length;
        int ch = 3;
        block3: for (int index = this.index; index < length; ++index) {
            ch = data[index];
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    throw new UnexpectedCharacterException("Junk", "Unexpected extra characters", this);
                }
            }
        }
    }

    @Override
    public int nextSkipWhiteSpace() {
        int index;
        char[] data = this.data;
        int length = data.length;
        int ch = 3;
        block3: for (index = this.index + 1; index < length; ++index) {
            ch = data[index];
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
            }
        }
        this.index = index;
        return index == length ? 3 : ch;
    }

    @Override
    public char skipWhiteSpace() {
        int index;
        char[] data = this.data;
        int length = data.length;
        block3: for (index = this.index; index < length; ++index) {
            char ch = data[index];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
        }
        this.index = index;
        return data[index];
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public char getCurrentChar() {
        return this.data[this.index];
    }

    @Override
    public char getCurrentCharSafe() {
        if (this.index >= this.data.length) {
            return '\u0003';
        }
        return this.data[this.index];
    }

    @Override
    public char getChartAt(int index) {
        return this.data[index];
    }

    @Override
    public String getString(int startIndex, int endIndex) {
        return new String(this.data, startIndex, endIndex - startIndex);
    }

    @Override
    public CharSequence getCharSequence(int startIndex, int endIndex) {
        return new CharArraySegment(startIndex, endIndex - startIndex, this.data);
    }

    @Override
    public char[] getArray(int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        char[] array = new char[length];
        System.arraycopy(this.data, startIndex, array, 0, length);
        return array;
    }

    @Override
    public BigDecimal getBigDecimal(int startIndex, int endIndex) {
        return new BigDecimal(this.data, startIndex, endIndex - startIndex);
    }

    @Override
    public BigInteger getBigInteger(int startIndex, int endIndex) {
        int len = endIndex - startIndex;
        if (len > MAX_LONG_STR_LENGTH) {
            return this.getBigDecimal(startIndex, endIndex).toBigInteger();
        }
        long value = this.getLong(startIndex, endIndex);
        return BigInteger.valueOf(value);
    }

    @Override
    public String getEncodedString(int start, int end) {
        return CharArrayUtils.decodeJsonString(this.data, start, end);
    }

    @Override
    public String toEncodedStringIfNeeded(int start, int end) {
        if (CharArrayUtils.hasEscapeChar(this.data, start, end)) {
            return this.getEncodedString(start, end);
        }
        return this.getString(start, end);
    }

    public String toString() {
        return new String(this.data);
    }

    @Override
    public NumberParseResult findEndOfNumberFast() {
        int i;
        char ch = '\u0000';
        char[] data = this.data;
        int length = data.length;
        block6: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    this.index = i;
                    return new NumberParseResult(i, false);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block6;
                }
                case '.': {
                    this.index = i;
                    return this.findEndOfFloatFast();
                }
                case 'E': 
                case 'e': {
                    this.index = i;
                    return this.parseFloatWithExponentFast();
                }
                default: {
                    throw new IllegalStateException("Unexpected character " + ch + " at index " + this.index);
                }
            }
        }
        this.index = i;
        return new NumberParseResult(i, false);
    }

    private NumberParseResult findEndOfFloatFast() {
        int i;
        char ch = '\u0000';
        char[] data = this.data;
        int length = data.length;
        block5: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    this.index = i;
                    return new NumberParseResult(i, true);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                case 'E': 
                case 'e': {
                    this.index = i;
                    return this.parseFloatWithExponentFast();
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing JSON Float Number", "Unexpected character", this, ch, i);
                }
            }
        }
        this.index = i;
        return new NumberParseResult(i, true);
    }

    private NumberParseResult parseFloatWithExponentFast() {
        int i;
        char ch = '\u0000';
        int signOperator = 0;
        char[] data = this.data;
        int length = data.length;
        block5: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    this.index = i;
                    return new NumberParseResult(i, true);
                }
                case '+': 
                case '-': {
                    if (++signOperator <= 1) continue block5;
                    throw new IllegalStateException("Too many sign operators when parsing exponent of float");
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Unexpected character " + ch + " at index " + this.index);
                }
            }
        }
        this.index = i;
        return new NumberParseResult(i, true);
    }

    @Override
    public int findEndOfEncodedStringFast() {
        char[] data = this.data;
        int length = data.length;
        boolean controlChar = false;
        block4: for (int i = ++this.index; i < length; ++i) {
            char ch = data[i];
            switch (ch) {
                case '\\': {
                    controlChar = !controlChar;
                    continue block4;
                }
                case '\"': {
                    if (!controlChar) {
                        this.index = i + 1;
                        return i;
                    }
                    controlChar = false;
                    continue block4;
                }
                default: {
                    controlChar = false;
                }
            }
        }
        throw new IllegalStateException("Unable to find closing for String");
    }

    private int findEndOfStringControlEncode(int i) {
        char[] data = this.data;
        int length = data.length;
        char ch = '\u0000';
        ch = data[i];
        switch (ch) {
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                return i;
            }
            case 'u': {
                return this.findEndOfHexEncoding(i);
            }
        }
        throw new UnexpectedCharacterException("Parsing JSON String", "Unexpected character while finding closing for String", this, ch, i);
    }

    @Override
    public int findEndOfEncodedString() {
        int i;
        char[] data = this.data;
        int length = data.length;
        char ch = '\u0000';
        block4: for (i = ++this.index; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\\': {
                    i = this.findEndOfStringControlEncode(i + 1);
                    continue block4;
                }
                case '\"': {
                    this.index = i + 1;
                    return i;
                }
                default: {
                    if (ch >= ' ') continue block4;
                    throw new UnexpectedCharacterException("Parsing JSON String", "Unexpected character while finding closing for String", this, ch, i);
                }
            }
        }
        throw new UnexpectedCharacterException("Parsing JSON Encoded String", "Unable to find closing for String", this, ch, i);
    }

    private int findEndOfHexEncoding(int index) {
        char[] data = this.data;
        int length = data.length;
        if (this.isHex(data[++index]) && this.isHex(data[++index]) && this.isHex(data[++index]) && this.isHex(data[++index])) {
            return index;
        }
        throw new UnexpectedCharacterException("Parsing hex encoding in a string", "Unexpected character", this);
    }

    private boolean isHex(char datum) {
        switch (datum) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    @Override
    public int findAttributeEnd() {
        int index;
        char[] data = this.data;
        int length = this.data.length;
        block3: for (index = this.index; index < length; ++index) {
            char ch = data[index];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ':': {
                    this.index = index;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        return index;
    }

    @Override
    public boolean findChar(char c) {
        char[] data = this.data;
        int length = this.data.length;
        for (int index = this.index; index < length; ++index) {
            if (data[index] != c) continue;
            this.index = index;
            return true;
        }
        return false;
    }

    @Override
    public int findEndString() {
        int i;
        char[] data = this.data;
        int length = data.length;
        char ch = '\u0000';
        for (i = ++this.index; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\"': {
                    this.index = i;
                    return i;
                }
            }
            if (ch >= ' ') continue;
            throw new UnexpectedCharacterException("Parsing JSON String", "Unexpected character while finding closing for String", this, ch, i);
        }
        throw new UnexpectedCharacterException("Parsing JSON String", "Unable to find closing for String", this, ch, i);
    }

    @Override
    public NumberParseResult findEndOfNumber() {
        int i;
        char startCh = this.getCurrentChar();
        int startIndex = this.index;
        char ch = startCh;
        char[] data = this.data;
        int length = data.length;
        block15: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    break block15;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block15;
                }
                case '.': {
                    int numLenSoFar;
                    if (startCh == '-' && (numLenSoFar = i - startIndex) == 1) {
                        throw new UnexpectedCharacterException("Parsing JSON Number", "Unexpected character", this, ch, i);
                    }
                    this.index = i;
                    return this.findEndOfFloat();
                }
                case 'E': 
                case 'e': {
                    this.index = i;
                    return this.parseFloatWithExponent();
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing JSON Number", "Unexpected character", this, ch, i);
                }
            }
        }
        this.index = i;
        int numLength = i - startIndex;
        block6 : switch (startCh) {
            case '0': {
                if (numLength == 1) break;
                throw new UnexpectedCharacterException("Parsing JSON Int Number", "Int can't start with a 0 ", this, startCh, startIndex);
            }
            case '+': {
                throw new UnexpectedCharacterException("Parsing JSON Int Number", "Int can't start with a plus ", this, startCh, startIndex);
            }
            case '-': {
                switch (numLength) {
                    case 1: {
                        throw new UnexpectedCharacterException("Parsing JSON Int Number", "Int can't be only a minus, number is missing", this, startCh, startIndex);
                    }
                    case 2: {
                        break block6;
                    }
                }
                if (data[startIndex + 1] != '0') break;
                throw new UnexpectedCharacterException("Parsing JSON Int Number", "0 can't be after minus sign", this, startCh, startIndex);
            }
        }
        return new NumberParseResult(i, false);
    }

    private NumberParseResult findEndOfFloat() {
        int i;
        char ch = (char)this.next();
        if (!this.isNumber(ch)) {
            throw new UnexpectedCharacterException("Parsing float part of number", "After decimal point expecting number but got", this, ch, this.index);
        }
        char[] data = this.data;
        int length = data.length;
        block5: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    this.index = i;
                    return new NumberParseResult(i, true);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block5;
                }
                case 'E': 
                case 'e': {
                    this.index = i;
                    return this.parseFloatWithExponent();
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing JSON Float Number", "Unexpected character", this, ch, i);
                }
            }
        }
        this.index = i;
        return new NumberParseResult(i, true);
    }

    private boolean isNumber(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private NumberParseResult parseFloatWithExponent() {
        int i;
        char ch = (char)this.next();
        if (!this.isNumberOrSign(ch)) {
            throw new UnexpectedCharacterException("Parsing exponent part of float", "After exponent expecting number or sign but got", this, ch, this.index);
        }
        if (this.isSign(ch) && !this.isNumber(ch = (char)this.next())) {
            throw new UnexpectedCharacterException("Parsing exponent part of float after sign", "After sign expecting number but got", this, ch, this.index);
        }
        char[] data = this.data;
        int length = data.length;
        block4: for (i = this.index + 1; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ']': 
                case '}': {
                    this.index = i;
                    return new NumberParseResult(i, true);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing Float with exponent", "Unable to find closing for Number", this, ch, i);
                }
            }
        }
        this.index = i;
        return new NumberParseResult(i, true);
    }

    private boolean isNumberOrSign(char ch) {
        switch (ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    private boolean isSign(char ch) {
        switch (ch) {
            case '+': 
            case '-': {
                return true;
            }
        }
        return false;
    }

    @Override
    public int findFalseEnd() {
        if (this.data[++this.index] == 'a' && this.data[++this.index] == 'l' && this.data[++this.index] == 's' && this.data[++this.index] == 'e') {
            return ++this.index;
        }
        throw new UnexpectedCharacterException("Parsing JSON False Boolean", "Unexpected character", this);
    }

    @Override
    public int findTrueEnd() {
        if (this.data[++this.index] == 'r' && this.data[++this.index] == 'u' && this.data[++this.index] == 'e') {
            return ++this.index;
        }
        throw new UnexpectedCharacterException("Parsing JSON True Boolean", "Unexpected character", this);
    }

    @Override
    public boolean findObjectEndOrAttributeSep() {
        char ch = '\u0000';
        char[] data = this.data;
        int length = data.length;
        for (int i = this.index; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case '}': {
                    this.index = i + 1;
                    return true;
                }
                case ':': {
                    this.index = i;
                    return false;
                }
            }
        }
        throw new UnexpectedCharacterException("Parsing Object Key", "Finding object end or separator", this);
    }

    @Override
    public boolean findCommaOrEndForArray() {
        char ch = '\u0000';
        char[] data = this.data;
        int length = data.length;
        block5: for (int i = this.index; i < length; ++i) {
            ch = data[i];
            switch (ch) {
                case ']': {
                    this.index = i + 1;
                    return true;
                }
                case ',': {
                    this.index = i;
                    return false;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                default: {
                    throw new UnexpectedCharacterException("Parsing Object Key", "Finding object end or separator", this, ch, i);
                }
            }
        }
        throw new UnexpectedCharacterException("Parsing Array", "Finding list end or separator", this);
    }

    @Override
    public int findNullEnd() {
        if (this.data[++this.index] == 'u' && this.data[++this.index] == 'l' && this.data[++this.index] == 'l') {
            return ++this.index;
        }
        throw new UnexpectedCharacterException("Parsing JSON Null", "Unexpected character", this);
    }

    @Override
    public boolean matchChars(int startIndex, int endIndex, CharSequence key) {
        int length = endIndex - startIndex;
        int idx = startIndex;
        switch (length) {
            case 1: {
                return key.charAt(0) == this.data[idx];
            }
            case 2: {
                return key.charAt(0) == this.data[idx] && key.charAt(1) == this.data[idx + 1];
            }
            case 3: {
                return key.charAt(0) == this.data[idx] && key.charAt(1) == this.data[idx + 1] && key.charAt(2) == this.data[idx + 2];
            }
            case 4: {
                return key.charAt(0) == this.data[idx] && key.charAt(1) == this.data[idx + 1] && key.charAt(2) == this.data[idx + 2] && key.charAt(3) == this.data[idx + 3];
            }
            case 5: {
                return key.charAt(1) == this.data[idx + 1] && key.charAt(3) == this.data[idx + 3] && key.charAt(0) == this.data[idx] && key.charAt(2) == this.data[idx + 2] && key.charAt(4) == this.data[idx + 4];
            }
            case 6: {
                return key.charAt(0) == this.data[idx] && key.charAt(5) == this.data[idx + 5] && key.charAt(3) == this.data[idx + 3] && key.charAt(1) == this.data[idx + 1] && key.charAt(2) == this.data[idx + 2] && key.charAt(4) == this.data[idx + 4];
            }
            case 7: {
                return key.charAt(0) == this.data[idx] && key.charAt(6) == this.data[idx + 6] && key.charAt(3) == this.data[idx + 3] && key.charAt(1) == this.data[idx + 1] && key.charAt(5) == this.data[idx + 5] && key.charAt(2) == this.data[idx + 2] && key.charAt(4) == this.data[idx + 4];
            }
            case 8: {
                return key.charAt(0) == this.data[idx] && key.charAt(7) == this.data[idx + 7] && key.charAt(3) == this.data[idx + 3] && key.charAt(1) == this.data[idx + 1] && key.charAt(5) == this.data[idx + 5] && key.charAt(2) == this.data[idx + 2] && key.charAt(6) == this.data[idx + 6] && key.charAt(4) == this.data[idx + 4];
            }
            case 9: {
                return key.charAt(0) == this.data[idx] && key.charAt(8) == this.data[idx + 8] && key.charAt(2) == this.data[idx + 2] && key.charAt(6) == this.data[idx + 6] && key.charAt(3) == this.data[idx + 3] && key.charAt(7) == this.data[idx + 7] && key.charAt(4) == this.data[idx + 4] && key.charAt(5) == this.data[idx + 5] && key.charAt(1) == this.data[idx + 1];
            }
            case 10: {
                return key.charAt(0) == this.data[idx] && key.charAt(9) == this.data[idx + 9] && key.charAt(6) == this.data[idx + 6] && key.charAt(3) == this.data[idx + 3] && key.charAt(7) == this.data[idx + 7] && key.charAt(2) == this.data[idx + 2] && key.charAt(4) == this.data[idx + 4] && key.charAt(5) == this.data[idx + 5] && key.charAt(1) == this.data[idx + 1] && key.charAt(8) == this.data[idx + 8];
            }
            case 11: {
                return key.charAt(0) == this.data[idx] && key.charAt(10) == this.data[idx + 10] && key.charAt(6) == this.data[idx + 6] && key.charAt(3) == this.data[idx + 3] && key.charAt(7) == this.data[idx + 7] && key.charAt(2) == this.data[idx + 2] && key.charAt(9) == this.data[idx + 9] && key.charAt(4) == this.data[idx + 4] && key.charAt(5) == this.data[idx + 5] && key.charAt(1) == this.data[idx + 1] && key.charAt(8) == this.data[idx + 8];
            }
            case 12: {
                return key.charAt(0) == this.data[idx] && key.charAt(11) == this.data[idx + 11] && key.charAt(3) == this.data[idx + 3] && key.charAt(7) == this.data[idx + 7] && key.charAt(2) == this.data[idx + 2] && key.charAt(6) == this.data[idx + 6] && key.charAt(9) == this.data[idx + 9] && key.charAt(4) == this.data[idx + 4] && key.charAt(5) == this.data[idx + 5] && key.charAt(10) == this.data[idx + 10] && key.charAt(1) == this.data[idx + 1] && key.charAt(8) == this.data[idx + 8];
            }
        }
        boolean start = false;
        int end = length - 1;
        int middle = length / 2;
        if (key.charAt(0) == this.data[idx] && key.charAt(end) == this.data[idx + end] && key.charAt(middle) == this.data[idx + middle]) {
            for (int i = 1; i < length; ++i) {
                if (key.charAt(i) == this.data[idx + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInteger(int offset, int end) {
        int cmpLen;
        int len = end - offset;
        char[] digitChars = this.data;
        boolean negative = digitChars[offset] == '-';
        int n = cmpLen = negative ? MIN_INT_STR_LENGTH : MAX_INT_STR_LENGTH;
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        char[] cmpStr = negative ? MIN_INT_CHARS : MAX_INT_CHARS;
        for (int i = 0; i < cmpLen; ++i) {
            int diff = digitChars[offset + i] - cmpStr[i];
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    @Override
    public double getDouble(int from, int to) {
        return ParseDouble.parseDouble(this.data, from, to);
    }

    @Override
    public float getFloat(int from, int to) {
        return ParseFloat.parseFloat(this.data, from, to);
    }

    @Override
    public int getInt(int offset, int to) {
        char[] digitChars = this.data;
        boolean negative = false;
        char c = digitChars[offset];
        if (c == '-') {
            ++offset;
            negative = true;
        } else if (c == '+') {
            ++offset;
            negative = false;
        }
        c = digitChars[offset];
        int num = c - 48;
        ++offset;
        while (offset < to) {
            c = digitChars[offset];
            int digit = c - 48;
            num = num * 10 + digit;
            ++offset;
        }
        return negative ? num * -1 : num;
    }

    @Override
    public long getLong(int offset, int to) {
        char[] digitChars = this.data;
        boolean negative = false;
        char c = digitChars[offset];
        if (c == '-') {
            ++offset;
            negative = true;
        }
        c = digitChars[offset];
        long num = c - 48;
        ++offset;
        while (offset < to) {
            c = digitChars[offset];
            long digit = c - 48;
            num = num * 10L + digit;
            ++offset;
        }
        return negative ? num * -1L : num;
    }

    @Override
    public String errorDetails(String message, int index, int ch) {
        StringBuilder buf = new StringBuilder(255);
        char[] array = this.data;
        buf.append(message).append("\n");
        buf.append("\n");
        buf.append("The current character read is " + CharArrayCharSource.debugCharDescription(ch)).append('\n');
        int line = 0;
        int lastLineIndex = 0;
        for (int i = 0; i < index && i < array.length; ++i) {
            if (array[i] != '\n') continue;
            ++line;
            lastLineIndex = i + 1;
        }
        int count = 0;
        int i = lastLineIndex;
        while (i < array.length && array[i] != '\n') {
            ++i;
            ++count;
        }
        buf.append("line number " + (line + 1)).append('\n');
        buf.append("index number " + index).append('\n');
        try {
            buf.append(new String(array, lastLineIndex, count)).append('\n');
        }
        catch (Exception ex) {
            try {
                index = index - 10 < 0 ? 0 : index - 10;
                int start = index;
                buf.append(new String(array, start, index)).append('\n');
            }
            catch (Exception ex2) {
                buf.append(new String(array)).append('\n');
            }
        }
        for (i = 0; i < index - lastLineIndex; ++i) {
            buf.append('.');
        }
        buf.append('^');
        return buf.toString();
    }
}

