/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source;

import io.nats.jparse.source.CharArrayCharSource;
import io.nats.jparse.source.CharArrayOffsetCharSource;
import io.nats.jparse.source.CharSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Sources {
    private Sources() {
    }

    public static CharSource charSeqSource(CharSequence source) {
        if (source instanceof String) {
            return new CharArrayCharSource((String)source);
        }
        return new CharArrayCharSource(source.toString());
    }

    public static CharSource stringSource(String source) {
        return Sources.charSource(source.toCharArray());
    }

    public static CharSource byteSource(byte[] source, Charset charset) {
        return new CharArrayCharSource(new String(source, charset));
    }

    public static CharSource byteSource(byte[] source) {
        return Sources.byteSource(source, StandardCharsets.UTF_8);
    }

    public static CharSource charSource(char[] source) {
        return new CharArrayCharSource(source);
    }

    public static CharSource charSource(int offset, char[] source) {
        return new CharArrayOffsetCharSource(offset, source.length, source);
    }

    public static CharSource charSource(int offset, int endIndex, char[] source) {
        return new CharArrayOffsetCharSource(offset, endIndex, source);
    }

    public static CharSource charBufferSource(CharBuffer source) {
        return Sources.charSeqSource(source);
    }

    public static CharSource fileSource(String fileNameSource) {
        return Sources.fileSource(fileNameSource, StandardCharsets.UTF_8);
    }

    public static CharSource fileSource(String fileNameSource, Charset charset) {
        try {
            return Sources.byteSource(Files.readAllBytes(Paths.get(fileNameSource, new String[0])), charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CharSource fileSource(File fileSource) {
        return Sources.fileSource(fileSource, StandardCharsets.UTF_8);
    }

    public static CharSource fileSource(File fileSource, Charset charset) {
        try {
            return Sources.byteSource(Files.readAllBytes(Paths.get(fileSource.getAbsolutePath(), new String[0])), charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static CharSource inputStreamSource(InputStream inputStreamSource, Charset charset) {
        return Sources.readerSource(new InputStreamReader(inputStreamSource, charset));
    }

    public static CharSource inputStreamSource(InputStream inputStreamSource) {
        return Sources.inputStreamSource(inputStreamSource, StandardCharsets.UTF_8);
    }

    public static CharSource readerSource(Reader readerSource) {
        BufferedReader reader = new BufferedReader(readerSource);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String s = reader.readLine();
            while (s != null) {
                stringBuilder.append(s).append('\n');
                s = reader.readLine();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return new CharArrayCharSource(stringBuilder.toString());
    }
}

