/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source.support;

public class CharArraySegment
implements CharSequence {
    private final int offset;
    private final int length;
    private final char[] data;

    public CharArraySegment(int offset, int length, char[] data) {
        this.offset = offset;
        this.length = length;
        this.data = data;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.data[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharArraySegment(start + this.offset, end - start, this.data);
    }

    @Override
    public String toString() {
        return new String(this.data, this.offset, this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharArraySegment) {
            CharArraySegment other = (CharArraySegment)o;
            if (other.length != this.length) {
                return false;
            }
            int end = this.length + this.offset;
            int i = this.offset;
            int j = other.offset;
            while (i < end) {
                char cOther = other.data[j];
                char cThis = this.data[i];
                if (cOther != cThis) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence other = (CharSequence)o;
            if (other.length() != this.length) {
                return false;
            }
            int end = this.length + this.offset;
            int i = this.offset;
            int j = 0;
            while (i < end) {
                char cThis;
                char cOther = other.charAt(j);
                if (cOther != (cThis = this.data[i])) {
                    return false;
                }
                ++i;
                ++j;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

