/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source.support;

import io.nats.jparse.source.support.UnexpectedCharacterException;

public class ParseDouble {
    static final double[] powersOf10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};

    private ParseDouble() {
    }

    public static double parseDouble(char[] chars, int startIndex, int endIndex) {
        boolean negative = false;
        int i = startIndex;
        double result = 0.0;
        if (chars[i] == '-') {
            negative = true;
            ++i;
        }
        block5: while (i < endIndex) {
            char ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result = result * 10.0 + (double)(ch - 48);
                    ++i;
                    break;
                }
                case '.': {
                    result = ParseDouble.parseFractionPart(i + 1, endIndex, chars, result);
                    break block5;
                }
                case 'E': 
                case 'e': {
                    result = ParseDouble.parseExponent(i + 1, endIndex, chars, result);
                    break block5;
                }
                default: {
                    throw new UnexpectedCharacterException("parsing double", "Illegal character", ch, i);
                }
            }
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    private static double parseFractionPart(int i, int endIndex, char[] chars, double result) {
        double fraction = 0.1;
        block4: while (i < endIndex) {
            char ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result += (double)(ch - 48) * fraction;
                    fraction /= 10.0;
                    ++i;
                    continue block4;
                }
                case 'E': 
                case 'e': {
                    return ParseDouble.parseExponent(i + 1, endIndex, chars, result);
                }
            }
            throw new UnexpectedCharacterException("double parsing fraction part", "Illegal character", ch, i);
        }
        return result;
    }

    private static double parseExponent(int i, int endIndex, char[] chars, double result) {
        boolean exponentNegative = false;
        int exponent = 0;
        char sign = chars[i];
        switch (sign) {
            case '-': {
                exponentNegative = true;
                ++i;
                break;
            }
            case '+': {
                ++i;
            }
        }
        block7: while (i < endIndex) {
            char ch = chars[i];
            switch (chars[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    exponent = exponent * 10 + (ch - 48);
                    ++i;
                    continue block7;
                }
            }
            throw new UnexpectedCharacterException("double parsing parsing exponent", "Illegal character", ch, i);
        }
        if (exponentNegative) {
            exponent = -exponent;
        }
        if (!exponentNegative) {
            while (exponent >= powersOf10.length) {
                result *= 1.0E22;
                exponent -= 22;
            }
            result *= powersOf10[exponent];
        } else {
            while (-exponent >= powersOf10.length) {
                result /= 1.0E22;
                exponent += 22;
            }
            result /= powersOf10[-exponent];
        }
        return result;
    }
}

