/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source.support;

import io.nats.jparse.source.support.UnexpectedCharacterException;

public class ParseFloat {
    static final float[] powersOf10 = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f, 1.0E11f, 1.0E12f, 1.0E13f, 1.0E14f, 1.0E15f, 1.0E16f, 1.0E17f, 1.0E18f};

    private ParseFloat() {
    }

    public static float parseFloat(char[] chars, int startIndex, int endIndex) {
        boolean negative = false;
        int i = startIndex;
        float result = 0.0f;
        if (chars[i] == '-') {
            negative = true;
            ++i;
        }
        block5: while (i < endIndex) {
            char ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result = result * 10.0f + (float)(ch - 48);
                    ++i;
                    break;
                }
                case '.': {
                    result = ParseFloat.parseFractionPart(i + 1, endIndex, chars, result);
                    break block5;
                }
                case 'e': {
                    result = ParseFloat.parseExponent(i + 1, endIndex, chars, result);
                    break block5;
                }
                default: {
                    throw new UnexpectedCharacterException("parsing float", "Illegal character", ch, i);
                }
            }
        }
        if (negative) {
            result = -result;
        }
        return result;
    }

    private static float parseFractionPart(int i, int endIndex, char[] chars, float result) {
        float fraction = 0.1f;
        block4: while (i < endIndex) {
            char ch = chars[i];
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    result += (float)(ch - 48) * fraction;
                    fraction /= 10.0f;
                    ++i;
                    continue block4;
                }
                case 'e': {
                    return ParseFloat.parseExponent(i + 1, endIndex, chars, result);
                }
            }
            throw new UnexpectedCharacterException("float parsing fraction part", "Illegal character", ch, i);
        }
        return result;
    }

    private static float parseExponent(int i, int endIndex, char[] chars, float result) {
        boolean exponentNegative = false;
        int exponent = 0;
        char sign = chars[i];
        switch (sign) {
            case '-': {
                exponentNegative = true;
                ++i;
                break;
            }
            case '+': {
                ++i;
            }
        }
        block7: while (i < endIndex) {
            char ch = chars[i];
            switch (chars[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    exponent = exponent * 10 + (ch - 48);
                    ++i;
                    continue block7;
                }
            }
            throw new UnexpectedCharacterException("float parsing exponent part", "Illegal character", ch, i);
        }
        if (exponentNegative) {
            exponent = -exponent;
        }
        if (!exponentNegative) {
            while (exponent >= powersOf10.length) {
                result *= 1.0E18f;
                exponent -= 18;
            }
            result *= powersOf10[exponent];
        } else {
            while (-exponent >= powersOf10.length) {
                result /= 1.0E18f;
                exponent += 18;
            }
            result /= powersOf10[-exponent];
        }
        return result;
    }
}

