/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.source.support;

import io.nats.jparse.source.CharSource;
import java.util.Optional;

public class UnexpectedCharacterException
extends RuntimeException {
    private final CharSource source;
    private final String whileDoing;
    private final String message;
    private final int index;
    private final int ch;

    public UnexpectedCharacterException(String whileDoing, String message, int ch, int index) {
        super(String.format("Unexpected character while %s, Error is '%s, character is %c' at index %d.", whileDoing, message, Character.valueOf((char)ch), index));
        this.source = null;
        this.whileDoing = whileDoing;
        this.message = message;
        this.ch = ch;
        this.index = index;
    }

    public UnexpectedCharacterException(String whileDoing, String message, CharSource source, int ch, int index) {
        super(String.format("Unexpected character while %s, Error is '%s'. \n Details \n %s", whileDoing, message, source.errorDetails(message, index, ch)));
        this.source = source;
        this.whileDoing = whileDoing;
        this.message = message;
        this.ch = ch;
        this.index = index;
    }

    public UnexpectedCharacterException(String whileDoing, String message, CharSource source, int ch) {
        this(whileDoing, message, source, ch, source.getIndex());
    }

    public UnexpectedCharacterException(String whileDoing, String message, CharSource source) {
        this(whileDoing, message, source, source.getCurrentCharSafe(), source.getIndex());
    }

    public UnexpectedCharacterException(String whileDoing, CharSource charSource, UnexpectedCharacterException unexpectedCharacterException) {
        this(whileDoing, unexpectedCharacterException.getLocalizedMessage(), charSource);
    }

    public Optional<CharSource> source() {
        return Optional.ofNullable(this.source);
    }

    public String getWhileDoing() {
        return this.whileDoing;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCh() {
        return this.ch;
    }

    public String getDetails() {
        return this.source.errorDetails(this.message, this.index, this.ch);
    }
}

