/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jparse.token;

import io.nats.jparse.source.CharSource;
import io.nats.jparse.token.TokenTypes;
import java.util.Objects;

public class Token {
    public final int startIndex;
    public final int endIndex;
    public final int type;

    public Token(int startIndex, int endIndex, int type) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.type = type;
    }

    public String asString(String buffer) {
        return buffer.substring(this.startIndex, this.endIndex);
    }

    public String asString(CharSource source) {
        return source.getString(this.startIndex, this.endIndex);
    }

    public int length() {
        return this.endIndex - this.startIndex;
    }

    public String toString() {
        return "Token{startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", type=" + TokenTypes.getTypeName(this.type) + " " + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.startIndex == token.startIndex && this.endIndex == token.endIndex && this.type == token.type;
    }

    public int hashCode() {
        return Objects.hash(this.startIndex, this.endIndex, this.type);
    }
}

