/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.JsonWriteUtils;
import io.nats.jwt.AuthorizationRequest;
import io.nats.jwt.AuthorizationResponse;
import io.nats.jwt.ClaimIssuer;
import io.nats.jwt.UserClaim;

public class Claim
implements JsonSerializable {
    public final String aud;
    public final long exp;
    public final String jti;
    public final long iat;
    public final String iss;
    public final String name;
    public final String nbf;
    public final String sub;
    public final String type;
    public final JsonSerializable nats;
    public final UserClaim userClaim;
    public final AuthorizationRequest authorizationRequest;
    public final AuthorizationResponse authorizationResponse;

    public Claim(String json) throws JsonParseException {
        this(JsonParser.parse((String)json));
    }

    public Claim(byte[] json) throws JsonParseException {
        this(JsonParser.parse((byte[])json));
    }

    public Claim(char[] json) throws JsonParseException {
        this(JsonParser.parse((char[])json));
    }

    Claim(ClaimIssuer issuer) {
        this.aud = issuer.aud;
        this.jti = issuer.jti;
        this.iat = issuer.iatResolved;
        this.iss = issuer.iss;
        this.exp = issuer.expResolved;
        this.name = issuer.name;
        this.nbf = issuer.nbf;
        this.sub = issuer.sub;
        this.nats = issuer.nats;
        UserClaim tempUserClaim = null;
        AuthorizationRequest tempAuthorizationRequest = null;
        AuthorizationResponse tempAuthorizationResponse = null;
        if (this.nats instanceof UserClaim) {
            tempUserClaim = (UserClaim)this.nats;
            this.type = tempUserClaim.getType();
        } else if (this.nats instanceof AuthorizationRequest) {
            tempAuthorizationRequest = (AuthorizationRequest)this.nats;
            this.type = tempAuthorizationRequest.getType();
        } else if (this.nats instanceof AuthorizationResponse) {
            tempAuthorizationResponse = (AuthorizationResponse)this.nats;
            this.type = tempAuthorizationResponse.getType();
        } else {
            this.type = JsonValueUtils.readString((JsonValue)this.nats.toJsonValue(), (String)"type");
        }
        this.userClaim = tempUserClaim;
        this.authorizationRequest = tempAuthorizationRequest;
        this.authorizationResponse = tempAuthorizationResponse;
    }

    public Claim(JsonValue jv) {
        this.aud = JsonValueUtils.readString((JsonValue)jv, (String)"aud");
        this.exp = JsonValueUtils.readLong((JsonValue)jv, (String)"exp", (long)-1L);
        this.jti = JsonValueUtils.readString((JsonValue)jv, (String)"jti");
        this.iat = JsonValueUtils.readLong((JsonValue)jv, (String)"iat", (long)-1L);
        this.iss = JsonValueUtils.readString((JsonValue)jv, (String)"iss");
        this.name = JsonValueUtils.readString((JsonValue)jv, (String)"name");
        this.nbf = JsonValueUtils.readString((JsonValue)jv, (String)"nbf");
        this.sub = JsonValueUtils.readString((JsonValue)jv, (String)"sub");
        JsonValue nats = JsonValueUtils.readValue((JsonValue)jv, (String)"nats");
        this.nats = nats;
        this.type = JsonValueUtils.readString((JsonValue)nats, (String)"type");
        if ("user".equals(this.type)) {
            this.userClaim = new UserClaim(nats);
            this.authorizationRequest = null;
            this.authorizationResponse = null;
        } else if ("authorization_request".equals(this.type)) {
            this.userClaim = null;
            this.authorizationRequest = new AuthorizationRequest(nats);
            this.authorizationResponse = null;
        } else if ("authorization_response".equals(this.type)) {
            this.userClaim = null;
            this.authorizationRequest = null;
            this.authorizationResponse = new AuthorizationResponse(nats);
        } else {
            this.userClaim = null;
            this.authorizationRequest = null;
            this.authorizationResponse = null;
        }
    }

    public String toJson() {
        return Claim.toJson(this, this.jti);
    }

    public static String toJson(Claim c, String jti) {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addField((StringBuilder)sb, (String)"aud", (String)c.aud);
        JsonWriteUtils.addFieldEvenEmpty((StringBuilder)sb, (String)"jti", (String)jti);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"iat", (Long)c.iat);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"iss", (String)c.iss);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"name", (String)c.name);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"sub", (String)c.sub);
        JsonWriteUtils.addFieldWhenGtZero((StringBuilder)sb, (String)"exp", (Long)c.exp);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"nbf", (String)c.nbf);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"nats", (JsonSerializable)c.nats);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }
}

