/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.JsonWriteUtils;
import java.util.Arrays;
import java.util.Objects;

public class ClientInfo
implements JsonSerializable {
    public final String host;
    public final long id;
    public final String user;
    public final String name;
    public final String[] tags;
    public final String nameTag;
    public final String kind;
    public final String type;
    public final String mqttId;
    public final String nonce;

    public static ClientInfo optionalInstance(JsonValue jv) {
        return jv == null ? null : new ClientInfo(jv);
    }

    public ClientInfo(JsonValue jv) {
        this.host = JsonValueUtils.readString((JsonValue)jv, (String)"host");
        this.id = JsonValueUtils.readLong((JsonValue)jv, (String)"id");
        this.user = JsonValueUtils.readString((JsonValue)jv, (String)"user");
        this.name = JsonValueUtils.readString((JsonValue)jv, (String)"name");
        this.tags = JsonValueUtils.readStringList((JsonValue)jv, (String)"tags").toArray(new String[0]);
        this.nameTag = JsonValueUtils.readString((JsonValue)jv, (String)"name_tag");
        this.kind = JsonValueUtils.readString((JsonValue)jv, (String)"kind");
        this.type = JsonValueUtils.readString((JsonValue)jv, (String)"type");
        this.mqttId = JsonValueUtils.readString((JsonValue)jv, (String)"mqtt_id");
        this.nonce = JsonValueUtils.readString((JsonValue)jv, (String)"nonce");
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addField((StringBuilder)sb, (String)"host", (String)this.host);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"id", (Long)this.id);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"user", (String)this.user);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"name", (String)this.name);
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"tags", (String[])this.tags);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"name_tag", (String)this.nameTag);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"kind", (String)this.kind);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"type", (String)this.type);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"mqtt_id", (String)this.mqttId);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"nonce", (String)this.nonce);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientInfo that = (ClientInfo)o;
        if (this.id != that.id) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Arrays.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.nameTag, that.nameTag)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.mqttId, that.mqttId)) {
            return false;
        }
        return Objects.equals(this.nonce, that.nonce);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.tags);
        result = 31 * result + (this.nameTag != null ? this.nameTag.hashCode() : 0);
        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.mqttId != null ? this.mqttId.hashCode() : 0);
        result = 31 * result + (this.nonce != null ? this.nonce.hashCode() : 0);
        return result;
    }
}

