/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.JsonWriteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class GenericClaimFields<B>
implements JsonSerializable {
    public List<String> tags;
    public String type;
    public int version;

    protected GenericClaimFields(String type, int version) {
        this.type = type;
        this.version = version;
    }

    protected GenericClaimFields(JsonValue jv, String expectedType, int ... validVersions) {
        this.type = JsonValueUtils.readString((JsonValue)jv, (String)"type");
        if (!this.type.equals(expectedType)) {
            throw new IllegalArgumentException("Invalid Claim Type '" + this.type + "', expecting '" + expectedType + "'");
        }
        this.tags = JsonValueUtils.readOptionalStringList((JsonValue)jv, (String)"tags");
        this.version = JsonValueUtils.readInteger((JsonValue)jv, (String)"version", (int)-1);
        for (int v : validVersions) {
            if (this.version != v) continue;
            return;
        }
        throw new IllegalArgumentException("Invalid Version '" + this.version + "'");
    }

    public String getType() {
        return this.type;
    }

    protected void baseJson(StringBuilder sb) {
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"tags", this.tags);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"type", (String)this.type);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"version", (Integer)this.version);
    }

    protected abstract B getThis();

    public B tags(String ... tags) {
        this.tags = tags == null ? null : new ArrayList<String>(Arrays.asList(tags));
        return this.getThis();
    }

    public B tags(List<String> tags) {
        this.tags = tags;
        return this.getThis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericClaimFields that = (GenericClaimFields)o;
        if (this.version != that.version) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int result = this.tags != null ? this.tags.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.version;
        return result;
    }
}

