/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.client.NKey;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.jwt.ClaimIssuer;
import io.nats.jwt.UserClaim;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.Duration;

public abstract class JwtUtils {
    public static final String USER_CLAIM_TYPE = "user";
    public static final String AUTH_REQUEST_CLAIM_TYPE = "authorization_request";
    public static final String AUTH_RESPONSE_CLAIM_TYPE = "authorization_response";
    public static final String ENCODED_CLAIM_HEADER = Encoding.toBase64Url((String)"{\"typ\":\"JWT\", \"alg\":\"ed25519-nkey\"}");
    public static final long NO_LIMIT = -1L;
    public static final String NATS_USER_JWT_FORMAT = "-----BEGIN NATS USER JWT-----\n%s\n------END NATS USER JWT------\n\n************************* IMPORTANT *************************\nNKEY Seed printed below can be used to sign and prove identity.\nNKEYs are sensitive and should be treated as secrets.\n\n-----BEGIN USER NKEY SEED-----\n%s\n------END USER NKEY SEED------\n\n*************************************************************\n";

    private JwtUtils() {
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, null, null, JwtUtils.currentTimeSeconds(), null, new UserClaim(accountId));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, null, JwtUtils.currentTimeSeconds(), null, new UserClaim(accountId));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String ... tags) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, JwtUtils.currentTimeSeconds(), null, (UserClaim)new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String[] tags, Long issuedAt) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, null, (UserClaim)new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String[] tags, Long issuedAt, String audience) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, audience, (UserClaim)new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, Long issuedAt, UserClaim nats) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, null, nats);
    }

    public static String issueUserJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, Long issuedAt, String audience, UserClaim nats) throws GeneralSecurityException, IOException {
        if (signingKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the signingKey parameter, but got " + signingKey.getType());
        }
        NKey accountKey = NKey.fromPublicKey((char[])nats.issuerAccount.toCharArray());
        if (accountKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the accountId parameter, but got " + accountKey.getType());
        }
        NKey userKey = NKey.fromPublicKey((char[])publicUserKey.toCharArray());
        if (userKey.getType() != NKey.Type.USER) {
            throw new IllegalArgumentException("issueUserJWT requires a user key for the publicUserKey parameter, but got " + userKey.getType());
        }
        String accSigningKeyPub = new String(signingKey.getPublicKey());
        String claimName = name == null || name.trim().isEmpty() ? publicUserKey : name;
        return JwtUtils.issueJWT(signingKey, publicUserKey, claimName, expiration, issuedAt, accSigningKeyPub, audience, nats);
    }

    public static String issueJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, Long issuedAt, String accSigningKeyPub, JsonSerializable nats) throws GeneralSecurityException, IOException {
        return JwtUtils.issueJWT(signingKey, publicUserKey, name, expiration, issuedAt, accSigningKeyPub, null, nats);
    }

    public static String issueJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, Long issuedAt, String accSigningKeyPub, String audience, JsonSerializable nats) throws GeneralSecurityException, IOException {
        return new ClaimIssuer().aud(audience).iat(issuedAt == null || issuedAt < 0L ? JwtUtils.currentTimeSeconds() : issuedAt).iss(accSigningKeyPub).name(name).sub(publicUserKey).expiresIn(expiration).nats(nats).issueJwt(signingKey);
    }

    public static String getClaimBody(String jwt) {
        return Encoding.fromBase64Url((String)jwt.split("\\.")[1]);
    }

    public static String getClaimBody(byte[] jwtBytes) {
        return JwtUtils.getClaimBody(new String(jwtBytes));
    }
}

