/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.JsonWriteUtils;
import java.time.Duration;
import java.util.Objects;

public class ResponsePermission
implements JsonSerializable {
    public int max;
    public Duration expires;

    public static ResponsePermission optionalInstance(JsonValue jv) {
        return jv == null ? null : new ResponsePermission(jv);
    }

    public ResponsePermission() {
    }

    public ResponsePermission(JsonValue jv) {
        this.max = JsonValueUtils.readInteger((JsonValue)jv, (String)"max", (int)0);
        this.expires = JsonValueUtils.readNanos((JsonValue)jv, (String)"ttl");
    }

    public ResponsePermission max(int max) {
        this.max = max;
        return this;
    }

    public ResponsePermission expires(Duration expires) {
        this.expires = expires;
        return this;
    }

    public ResponsePermission expires(long expiresMillis) {
        this.expires = Duration.ofMillis(expiresMillis);
        return this;
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addField((StringBuilder)sb, (String)"max", (Integer)this.max);
        JsonWriteUtils.addFieldAsNanos((StringBuilder)sb, (String)"ttl", (Duration)this.expires);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponsePermission that = (ResponsePermission)o;
        if (this.max != that.max) {
            return false;
        }
        return Objects.equals(this.expires, that.expires);
    }

    public int hashCode() {
        int result = this.max;
        result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
        return result;
    }
}

