/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.json.JsonSerializable;
import io.nats.json.JsonValue;
import io.nats.json.JsonValueUtils;
import io.nats.json.JsonWriteUtils;
import io.nats.jwt.ClientInfo;
import io.nats.jwt.ClientTls;
import io.nats.jwt.ConnectOpts;
import io.nats.jwt.GenericClaimFields;
import io.nats.jwt.ServerId;
import java.util.Objects;

public class AuthorizationRequest
extends GenericClaimFields<AuthorizationRequest> {
    public ServerId serverId;
    public String userNkey;
    public ClientInfo clientInfo;
    public ConnectOpts connectOpts;
    public ClientTls clientTls;
    public String requestNonce;

    public AuthorizationRequest() {
        super("authorization_request", 2);
    }

    public AuthorizationRequest(JsonValue jv) {
        super(jv, "authorization_request", 2);
        this.serverId = ServerId.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"server_id"));
        this.userNkey = JsonValueUtils.readString((JsonValue)jv, (String)"user_nkey");
        this.clientInfo = ClientInfo.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"client_info"));
        this.connectOpts = ConnectOpts.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"connect_opts"));
        this.clientTls = ClientTls.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"client_tls"));
        this.requestNonce = JsonValueUtils.readString((JsonValue)jv, (String)"request_nonce");
    }

    @Override
    protected AuthorizationRequest getThis() {
        return this;
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        this.baseJson(sb);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"server_id", (JsonSerializable)this.serverId);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"user_nkey", (String)this.userNkey);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"client_info", (JsonSerializable)this.clientInfo);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"connect_opts", (JsonSerializable)this.connectOpts);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"client_tls", (JsonSerializable)this.clientTls);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"request_nonce", (String)this.requestNonce);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public AuthorizationRequest serverId(ServerId serverId) {
        this.serverId = serverId;
        return this;
    }

    public AuthorizationRequest userNkey(String userNkey) {
        this.userNkey = userNkey;
        return this;
    }

    public AuthorizationRequest clientInformation(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    public AuthorizationRequest connectOptions(ConnectOpts connectOpts) {
        this.connectOpts = connectOpts;
        return this;
    }

    public AuthorizationRequest clientTls(ClientTls clientTls) {
        this.clientTls = clientTls;
        return this;
    }

    public AuthorizationRequest requestNonce(String requestNonce) {
        this.requestNonce = requestNonce;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthorizationRequest that = (AuthorizationRequest)o;
        if (!Objects.equals(this.serverId, that.serverId)) {
            return false;
        }
        if (!Objects.equals(this.userNkey, that.userNkey)) {
            return false;
        }
        if (!Objects.equals(this.clientInfo, that.clientInfo)) {
            return false;
        }
        if (!Objects.equals(this.connectOpts, that.connectOpts)) {
            return false;
        }
        if (!Objects.equals(this.clientTls, that.clientTls)) {
            return false;
        }
        return Objects.equals(this.requestNonce, that.requestNonce);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.serverId != null ? this.serverId.hashCode() : 0);
        result = 31 * result + (this.userNkey != null ? this.userNkey.hashCode() : 0);
        result = 31 * result + (this.clientInfo != null ? this.clientInfo.hashCode() : 0);
        result = 31 * result + (this.connectOpts != null ? this.connectOpts.hashCode() : 0);
        result = 31 * result + (this.clientTls != null ? this.clientTls.hashCode() : 0);
        result = 31 * result + (this.requestNonce != null ? this.requestNonce.hashCode() : 0);
        return result;
    }
}

