/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.json.JsonParseException;
import io.nats.json.JsonParser;
import io.nats.json.JsonValue;
import io.nats.json.JsonValueUtils;
import io.nats.json.JsonWriteUtils;
import io.nats.jwt.GenericClaimFields;
import java.util.Objects;

public class AuthorizationResponse
extends GenericClaimFields<AuthorizationResponse> {
    public String jwt;
    public String error;
    public String issuerAccount;

    public AuthorizationResponse() {
        super("authorization_response", 2);
    }

    public AuthorizationResponse(String json) throws JsonParseException {
        this(JsonParser.parse((String)json));
    }

    public AuthorizationResponse(JsonValue jv) {
        super(jv, "authorization_response", 2);
        this.jwt = JsonValueUtils.readString((JsonValue)jv, (String)"jwt");
        this.error = JsonValueUtils.readString((JsonValue)jv, (String)"error");
        this.issuerAccount = JsonValueUtils.readString((JsonValue)jv, (String)"issuer_account");
    }

    @Override
    protected AuthorizationResponse getThis() {
        return this;
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addField((StringBuilder)sb, (String)"jwt", (String)this.jwt);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"error", (String)this.error);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"issuer_account", (String)this.issuerAccount);
        this.baseJson(sb);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public AuthorizationResponse jwt(String jwt) {
        this.jwt = jwt;
        return this;
    }

    public AuthorizationResponse error(String error) {
        this.error = error;
        return this;
    }

    public AuthorizationResponse issuerAccount(String issuerAccount) {
        this.issuerAccount = issuerAccount;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthorizationResponse that = (AuthorizationResponse)o;
        if (!Objects.equals(this.jwt, that.jwt)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        return Objects.equals(this.issuerAccount, that.issuerAccount);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.jwt != null ? this.jwt.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.issuerAccount != null ? this.issuerAccount.hashCode() : 0);
        return result;
    }
}

