/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.json.Encoding;
import io.nats.json.JsonSerializable;
import io.nats.jwt.Claim;
import io.nats.jwt.JwtUtils;
import io.nats.nkey.NKey;
import io.nats.nkey.NKeyUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Duration;

public class ClaimIssuer {
    String aud;
    String jti;
    Long iatInput;
    Long expInput;
    long iatResolved;
    long expResolved;
    String iss;
    String name;
    String nbf;
    String sub;
    JsonSerializable nats;
    Duration expiresInInput;

    public String issueJwt(NKey signingKey) throws GeneralSecurityException, IOException {
        long millis;
        long l = this.iatResolved = this.iatInput == null ? JwtUtils.currentTimeSeconds() : this.iatInput;
        if (this.expInput == null && this.expiresInInput != null && (millis = this.expiresInInput.toMillis()) > 0L) {
            this.expInput = this.iatResolved + millis / 1000L;
        }
        this.expResolved = this.expInput == null ? 0L : this.expInput;
        Claim claim = new Claim(this);
        String initialJson = claim.toJson();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] encoded = sha256.digest(initialJson.getBytes(StandardCharsets.US_ASCII));
        String issueJti = new String(NKeyUtils.base32Encode((byte[])encoded));
        initialJson = Claim.toJson(claim, issueJti);
        String encBody = Encoding.toBase64Url((String)initialJson);
        byte[] sig = (JwtUtils.ENCODED_CLAIM_HEADER + "." + encBody).getBytes(StandardCharsets.UTF_8);
        String encSig = Encoding.toBase64Url((byte[])signingKey.sign(sig));
        return JwtUtils.ENCODED_CLAIM_HEADER + "." + encBody + "." + encSig;
    }

    public ClaimIssuer nats(JsonSerializable nats) {
        this.nats = nats;
        return this;
    }

    public ClaimIssuer aud(String aud) {
        this.aud = aud;
        return this;
    }

    public ClaimIssuer iss(String iss) {
        this.iss = iss;
        return this;
    }

    public ClaimIssuer name(String name) {
        this.name = name;
        return this;
    }

    public ClaimIssuer nbf(String nbf) {
        this.nbf = nbf;
        return this;
    }

    public ClaimIssuer sub(String sub) {
        this.sub = sub;
        return this;
    }

    public ClaimIssuer iat(long iat) {
        this.iatInput = iat;
        return this;
    }

    public ClaimIssuer exp(Long exp) {
        this.expInput = exp;
        return this;
    }

    public ClaimIssuer expiresIn(Duration expiresIn) {
        this.expiresInInput = expiresIn;
        return this;
    }
}

