/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.json.JsonSerializable;
import io.nats.json.JsonValue;
import io.nats.json.JsonValueUtils;
import io.nats.json.JsonWriteUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Permission
implements JsonSerializable {
    public List<String> allow;
    public List<String> deny;

    public static Permission optionalInstance(JsonValue jv) {
        return jv == null ? null : new Permission(jv);
    }

    public Permission() {
    }

    public Permission(JsonValue jv) {
        this.allow = JsonValueUtils.readStringList((JsonValue)jv, (String)"allow");
        this.deny = JsonValueUtils.readStringList((JsonValue)jv, (String)"deny");
    }

    public Permission allow(String ... allow) {
        this.allow = Arrays.asList(allow);
        return this;
    }

    public Permission allow(List<String> allow) {
        this.allow = allow;
        return this;
    }

    public Permission deny(String ... deny) {
        this.deny = Arrays.asList(deny);
        return this;
    }

    public Permission deny(List<String> deny) {
        this.deny = deny;
        return this;
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"allow", this.allow);
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"deny", this.deny);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Permission that = (Permission)o;
        if (!Objects.equals(this.allow, that.allow)) {
            return false;
        }
        return Objects.equals(this.deny, that.deny);
    }

    public int hashCode() {
        int result = this.allow != null ? this.allow.hashCode() : 0;
        result = 31 * result + (this.deny != null ? this.deny.hashCode() : 0);
        return result;
    }
}

