/*
 * Decompiled with CFR 0.152.
 */
package io.nats.jwt;

import io.nats.json.JsonSerializable;
import io.nats.json.JsonValue;
import io.nats.json.JsonValueUtils;
import io.nats.json.JsonWriteUtils;
import io.nats.jwt.GenericClaimFields;
import io.nats.jwt.Permission;
import io.nats.jwt.ResponsePermission;
import io.nats.jwt.TimeRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UserClaim
extends GenericClaimFields<UserClaim> {
    public String issuerAccount;
    public Permission pub;
    public Permission sub;
    public ResponsePermission resp;
    public List<String> src;
    public List<TimeRange> timeRanges;
    public String locale;
    public long subs = -1L;
    public long data = -1L;
    public long payload = -1L;
    public boolean bearerToken;
    public List<String> allowedConnectionTypes;

    public UserClaim() {
        super("user", 2);
    }

    public UserClaim(String issuerAccount) {
        super("user", 2);
        this.issuerAccount = issuerAccount;
    }

    public UserClaim(JsonValue jv) {
        super(jv, "user", 2);
        this.issuerAccount = JsonValueUtils.readString((JsonValue)jv, (String)"issuer_account");
        this.pub = Permission.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"pub"));
        this.sub = Permission.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"sub"));
        this.resp = ResponsePermission.optionalInstance(JsonValueUtils.readValue((JsonValue)jv, (String)"resp"));
        this.src = JsonValueUtils.readOptionalStringList((JsonValue)jv, (String)"src");
        this.timeRanges = TimeRange.optionalListOf(JsonValueUtils.readValue((JsonValue)jv, (String)"times"));
        this.locale = JsonValueUtils.readString((JsonValue)jv, (String)"times_location");
        this.subs = JsonValueUtils.readLong((JsonValue)jv, (String)"subs", (long)-1L);
        this.data = JsonValueUtils.readLong((JsonValue)jv, (String)"data", (long)-1L);
        this.payload = JsonValueUtils.readLong((JsonValue)jv, (String)"payload", (long)-1L);
        this.bearerToken = JsonValueUtils.readBoolean((JsonValue)jv, (String)"bearer_token");
        this.allowedConnectionTypes = JsonValueUtils.readOptionalStringList((JsonValue)jv, (String)"allowed_connection_types");
    }

    @Override
    protected UserClaim getThis() {
        return this;
    }

    public String toJson() {
        StringBuilder sb = JsonWriteUtils.beginJson();
        JsonWriteUtils.addField((StringBuilder)sb, (String)"issuer_account", (String)this.issuerAccount);
        this.baseJson(sb);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"pub", (JsonSerializable)this.pub);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"sub", (JsonSerializable)this.sub);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"resp", (JsonSerializable)this.resp);
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"src", this.src);
        JsonWriteUtils.addJsons((StringBuilder)sb, (String)"times", this.timeRanges);
        JsonWriteUtils.addField((StringBuilder)sb, (String)"times_location", (String)this.locale);
        JsonWriteUtils.addFieldWhenGteMinusOne((StringBuilder)sb, (String)"subs", (Long)this.subs);
        JsonWriteUtils.addFieldWhenGteMinusOne((StringBuilder)sb, (String)"data", (Long)this.data);
        JsonWriteUtils.addFieldWhenGteMinusOne((StringBuilder)sb, (String)"payload", (Long)this.payload);
        JsonWriteUtils.addFldWhenTrue((StringBuilder)sb, (String)"bearer_token", (Boolean)this.bearerToken);
        JsonWriteUtils.addStrings((StringBuilder)sb, (String)"allowed_connection_types", this.allowedConnectionTypes);
        return JsonWriteUtils.endJson((StringBuilder)sb).toString();
    }

    public UserClaim issuerAccount(String issuerAccount) {
        this.issuerAccount = issuerAccount;
        return this;
    }

    public UserClaim pub(Permission pub) {
        this.pub = pub;
        return this;
    }

    public UserClaim sub(Permission sub) {
        this.sub = sub;
        return this;
    }

    public UserClaim resp(ResponsePermission resp) {
        this.resp = resp;
        return this;
    }

    public UserClaim src(String ... src) {
        this.src = new ArrayList<String>(Arrays.asList(src));
        return this;
    }

    public UserClaim src(List<String> src) {
        this.src = src;
        return this;
    }

    public UserClaim timeRanges(List<TimeRange> times) {
        this.timeRanges = times;
        return this;
    }

    public UserClaim locale(String locale) {
        this.locale = locale;
        return this;
    }

    public UserClaim subs(long subs) {
        this.subs = subs;
        return this;
    }

    public UserClaim data(long data) {
        this.data = data;
        return this;
    }

    public UserClaim payload(long payload) {
        this.payload = payload;
        return this;
    }

    public UserClaim bearerToken(boolean bearerToken) {
        this.bearerToken = bearerToken;
        return this;
    }

    public UserClaim allowedConnectionTypes(String ... allowedConnectionTypes) {
        this.allowedConnectionTypes = Arrays.asList(allowedConnectionTypes);
        return this;
    }

    public UserClaim allowedConnectionTypes(List<String> allowedConnectionTypes) {
        this.allowedConnectionTypes = allowedConnectionTypes;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserClaim userClaim = (UserClaim)o;
        if (this.subs != userClaim.subs) {
            return false;
        }
        if (this.data != userClaim.data) {
            return false;
        }
        if (this.payload != userClaim.payload) {
            return false;
        }
        if (this.bearerToken != userClaim.bearerToken) {
            return false;
        }
        if (!Objects.equals(this.issuerAccount, userClaim.issuerAccount)) {
            return false;
        }
        if (!Objects.equals(this.pub, userClaim.pub)) {
            return false;
        }
        if (!Objects.equals(this.sub, userClaim.sub)) {
            return false;
        }
        if (!Objects.equals(this.resp, userClaim.resp)) {
            return false;
        }
        if (!Objects.equals(this.src, userClaim.src)) {
            return false;
        }
        if (!Objects.equals(this.timeRanges, userClaim.timeRanges)) {
            return false;
        }
        if (!Objects.equals(this.locale, userClaim.locale)) {
            return false;
        }
        return Objects.equals(this.allowedConnectionTypes, userClaim.allowedConnectionTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.issuerAccount != null ? this.issuerAccount.hashCode() : 0);
        result = 31 * result + (this.pub != null ? this.pub.hashCode() : 0);
        result = 31 * result + (this.sub != null ? this.sub.hashCode() : 0);
        result = 31 * result + (this.resp != null ? this.resp.hashCode() : 0);
        result = 31 * result + (this.src != null ? this.src.hashCode() : 0);
        result = 31 * result + (this.timeRanges != null ? this.timeRanges.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (int)(this.subs ^ this.subs >>> 32);
        result = 31 * result + (int)(this.data ^ this.data >>> 32);
        result = 31 * result + (int)(this.payload ^ this.payload >>> 32);
        result = 31 * result + (this.bearerToken ? 1 : 0);
        result = 31 * result + (this.allowedConnectionTypes != null ? this.allowedConnectionTypes.hashCode() : 0);
        return result;
    }
}

