/*
 * Decompiled with CFR 0.152.
 */
package io.nats.cloud.stream.binder;

import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.cloud.stream.binder.NatsChannelBinder;
import io.nats.cloud.stream.binder.NatsChannelProvisioner;
import io.nats.cloud.stream.binder.properties.NatsBinderConfigurationProperties;
import io.nats.cloud.stream.binder.properties.NatsExtendedBindingProperties;
import io.nats.spring.boot.autoconfigure.NatsAutoConfiguration;
import io.nats.spring.boot.autoconfigure.NatsProperties;
import java.io.IOException;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.cloud.stream.config.BindingHandlerAdvise;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={NatsAutoConfiguration.class, PropertyPlaceholderAutoConfiguration.class})
@EnableConfigurationProperties(value={NatsExtendedBindingProperties.class, NatsBinderConfigurationProperties.class})
public class NatsChannelBinderConfiguration {
    @Autowired(required=false)
    private ConnectionListener connectionListener;
    @Autowired(required=false)
    private ErrorListener errorListener;
    @Autowired
    private NatsProperties natsProperties;
    @Autowired
    private NatsBinderConfigurationProperties natsBinderConfigurationProperties;
    @Autowired
    private NatsExtendedBindingProperties natsExtendedBindingProperties;

    public NatsBinderConfigurationProperties getNatsBinderConfigurationProperties() {
        return this.natsBinderConfigurationProperties;
    }

    public void setNatsBinderConfigurationProperties(NatsBinderConfigurationProperties natsBinderConfigurationProperties) {
        this.natsBinderConfigurationProperties = natsBinderConfigurationProperties;
    }

    public NatsExtendedBindingProperties getNatsExtendedBindingProperties() {
        return this.natsExtendedBindingProperties;
    }

    public void setNatsExtendedBindingProperties(NatsExtendedBindingProperties natsExtendedBindingProperties) {
        this.natsExtendedBindingProperties = natsExtendedBindingProperties;
    }

    public NatsProperties getNatsProperties() {
        return this.natsProperties;
    }

    public void setNatsProperties(NatsProperties natsProperties) {
        this.natsProperties = natsProperties;
    }

    @Bean
    public NatsChannelProvisioner natsChannelProvisioner() {
        return new NatsChannelProvisioner();
    }

    @Bean
    public NatsChannelBinder natsBinder(NatsChannelProvisioner natsProvisioner) throws IOException, InterruptedException {
        NatsChannelBinder binder = new NatsChannelBinder(this.natsExtendedBindingProperties, this.natsBinderConfigurationProperties, this.natsProperties, natsProvisioner, this.connectionListener, this.errorListener);
        return binder.getConnection() != null ? binder : null;
    }

    @Bean
    public BindingHandlerAdvise.MappingsProvider natsExtendedPropertiesDefaultMappingsProvider() {
        return () -> Collections.singletonMap(ConfigurationPropertyName.of((CharSequence)"nats.spring.cloud.stream"), ConfigurationPropertyName.of((CharSequence)"nats.spring.cloud.stream"));
    }
}

