/*
 * Decompiled with CFR 0.152.
 */
package io.nats.cloud.stream.binder;

import io.nats.client.Connection;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;

public class NatsMessageHandler
extends AbstractMessageHandler {
    private static final Log logger = LogFactory.getLog(NatsMessageHandler.class);
    private String subject;
    private Connection connection;

    public NatsMessageHandler(String subject, Connection nc) {
        this.subject = subject;
        this.connection = nc;
    }

    protected void handleMessageInternal(Message<?> message) {
        String subj;
        Object payload = message.getPayload();
        byte[] bytes = null;
        if (payload instanceof byte[]) {
            bytes = (byte[])payload;
        } else if (payload instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)payload;
            bytes = new byte[buf.remaining()];
            buf.get(bytes);
        } else if (payload instanceof String) {
            bytes = ((String)payload).getBytes(StandardCharsets.UTF_8);
        }
        if (bytes == null) {
            logger.warn((Object)"NATS handler only supports byte array, byte buffer and string messages");
            return;
        }
        Object rt = message.getHeaders().get((Object)"reply_to");
        String replyTo = rt != null ? rt.toString() : null;
        String string = subj = replyTo != null ? replyTo : this.subject;
        if (this.connection != null && subj != null && subj.length() > 0) {
            this.connection.publish(subj, bytes);
        }
    }
}

