/*
 * Decompiled with CFR 0.152.
 */
package io.nats.cloud.stream.binder;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.cloud.stream.binder.NatsChannelProvisioner;
import io.nats.cloud.stream.binder.NatsConsumerDestination;
import io.nats.cloud.stream.binder.NatsMessageHandler;
import io.nats.cloud.stream.binder.NatsMessageProducer;
import io.nats.cloud.stream.binder.NatsMessageSource;
import io.nats.cloud.stream.binder.properties.NatsBinderConfigurationProperties;
import io.nats.cloud.stream.binder.properties.NatsConsumerProperties;
import io.nats.cloud.stream.binder.properties.NatsExtendedBindingProperties;
import io.nats.cloud.stream.binder.properties.NatsProducerProperties;
import io.nats.spring.boot.autoconfigure.NatsProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.AbstractMessageChannelBinder;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

public class NatsChannelBinder
extends AbstractMessageChannelBinder<ExtendedConsumerProperties<NatsConsumerProperties>, ExtendedProducerProperties<NatsProducerProperties>, NatsChannelProvisioner>
implements ExtendedPropertiesBinder<MessageChannel, NatsConsumerProperties, NatsProducerProperties> {
    private static final Log logger = LogFactory.getLog(NatsChannelBinder.class);
    private final NatsExtendedBindingProperties bindingProperties;
    private NatsBinderConfigurationProperties properties;
    private NatsProperties natsProperties;
    private Connection connection;

    public NatsChannelBinder(NatsExtendedBindingProperties bindingProperties, NatsBinderConfigurationProperties properties, NatsProperties natsProperties, NatsChannelProvisioner provisioningProvider, ConnectionListener connectionListener, ErrorListener errorListener) {
        super(null, (ProvisioningProvider)provisioningProvider);
        this.bindingProperties = bindingProperties;
        this.properties = properties;
        this.natsProperties = natsProperties;
        try {
            String globalServer;
            Options.Builder builder = null;
            String bindingServer = this.properties != null ? this.properties.getServer() : null;
            String string = globalServer = this.natsProperties != null ? this.natsProperties.getServer() : null;
            if (bindingServer != null && bindingServer.length() > 0) {
                logger.info((Object)("binder connecting to nats with named properties " + (Object)((Object)this.properties)));
                builder = this.properties.toOptionsBuilder();
            } else if (globalServer != null && globalServer.length() > 0) {
                logger.info((Object)("binder connecting to nats with global properties " + this.natsProperties));
                builder = this.natsProperties.toOptionsBuilder();
            } else {
                this.connection = null;
                logger.info((Object)"unable to connect from binder to NATS no server properties where found");
                return;
            }
            builder = connectionListener != null ? builder.connectionListener(connectionListener) : builder.connectionListener(new ConnectionListener(){

                public void connectionEvent(Connection conn, ConnectionListener.Events type) {
                    logger.info((Object)("NATS connection status changed " + type));
                }
            });
            builder = errorListener != null ? builder.errorListener(errorListener) : builder.errorListener(new ErrorListener(){

                public void slowConsumerDetected(Connection conn, Consumer consumer) {
                    logger.info((Object)"NATS connection slow consumer detected");
                }

                public void exceptionOccurred(Connection conn, Exception exp) {
                    logger.info((Object)"NATS connection exception occurred", (Throwable)exp);
                }

                public void errorOccurred(Connection conn, String error) {
                    logger.info((Object)("NATS connection error occurred " + error));
                }
            });
            this.connection = Nats.connect((Options)builder.build());
        }
        catch (Exception e) {
            logger.info((Object)"exception connecting binder to NATS", (Throwable)e);
            this.connection = null;
        }
        if (this.connection == null) {
            logger.info((Object)"unable to connect from binder to NATS");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, ExtendedProducerProperties<NatsProducerProperties> producerProperties, MessageChannel errorChannel) {
        return new NatsMessageHandler(destination.getName(), this.connection);
    }

    protected MessageProducer createConsumerEndpoint(ConsumerDestination destination, String group, ExtendedConsumerProperties<NatsConsumerProperties> properties) {
        return new NatsMessageProducer((NatsConsumerDestination)destination, this.connection);
    }

    protected AbstractMessageChannelBinder.PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, ExtendedConsumerProperties<NatsConsumerProperties> consumerProperties) {
        return new AbstractMessageChannelBinder.PolledConsumerResources((MessageSource)new NatsMessageSource((NatsConsumerDestination)destination, this.connection), this.registerErrorInfrastructure(destination, group, (ConsumerProperties)consumerProperties, true));
    }

    public NatsConsumerProperties getExtendedConsumerProperties(String channelName) {
        return (NatsConsumerProperties)this.bindingProperties.getExtendedConsumerProperties(channelName);
    }

    public NatsProducerProperties getExtendedProducerProperties(String channelName) {
        return (NatsProducerProperties)this.bindingProperties.getExtendedProducerProperties(channelName);
    }

    public String getDefaultsPrefix() {
        return this.bindingProperties.getDefaultsPrefix();
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return this.bindingProperties.getExtendedPropertiesEntryClass();
    }
}

