/*
 * Decompiled with CFR 0.152.
 */
package io.nats.cloud.stream.binder;

import io.nats.client.NUID;
import io.nats.cloud.stream.binder.NatsConsumerDestination;
import io.nats.cloud.stream.binder.NatsProducerDestination;
import io.nats.cloud.stream.binder.properties.NatsConsumerProperties;
import io.nats.cloud.stream.binder.properties.NatsProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;

public class NatsChannelProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<NatsConsumerProperties>, ExtendedProducerProperties<NatsProducerProperties>> {
    public ProducerDestination provisionProducerDestination(String subject, ExtendedProducerProperties<NatsProducerProperties> properties) throws ProvisioningException {
        return new NatsProducerDestination(subject);
    }

    public ConsumerDestination provisionConsumerDestination(String subject, String group, ExtendedConsumerProperties<NatsConsumerProperties> properties) throws ProvisioningException {
        String subscriptionName = group != null && group.length() > 0 ? subject + "#" + group : "anonymous#" + subject + "#" + NUID.nextGlobal();
        return new NatsConsumerDestination(subscriptionName);
    }
}

