/*
 * Decompiled with CFR 0.152.
 */
package io.nats.cloud.stream.binder;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.cloud.stream.binder.NatsConsumerDestination;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.GenericMessage;

public class NatsMessageProducer
implements MessageProducer,
Lifecycle {
    private static final Log logger = LogFactory.getLog(NatsMessageProducer.class);
    public static final String SUBJECT = "subject";
    private NatsConsumerDestination destination;
    private Connection connection;
    private MessageChannel output;
    private Dispatcher dispatcher;

    public NatsMessageProducer(NatsConsumerDestination destination, Connection nc) {
        this.destination = destination;
        this.connection = nc;
    }

    public MessageChannel getOutputChannel() {
        return this.output;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.output = outputChannel;
    }

    public boolean isRunning() {
        return this.dispatcher != null;
    }

    public void start() {
        if (this.dispatcher != null) {
            return;
        }
        this.dispatcher = this.connection.createDispatcher(msg -> {
            if (this.output == null) {
                logger.warn((Object)("skipping message, no output channel set for " + this.destination.getName()));
                return;
            }
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put(SUBJECT, msg.getSubject());
                headers.put("replyChannel", msg.getReplyTo());
                GenericMessage m = new GenericMessage((Object)msg.getData(), headers);
                this.output.send((Message)m);
            }
            catch (Exception e) {
                logger.warn((Object)"exception sending message to output channel", (Throwable)e);
            }
        });
        String sub = this.destination.getSubject();
        String queue = this.destination.getQueueGroup();
        if (queue != null && queue.length() > 0) {
            this.dispatcher.subscribe(sub, queue);
        } else {
            this.dispatcher.subscribe(sub);
        }
    }

    public void stop() {
        if (this.dispatcher == null) {
            return;
        }
        this.connection.closeDispatcher(this.dispatcher);
        this.dispatcher = null;
    }
}

