/*
 * Decompiled with CFR 0.152.
 */
package io.nats.spring.boot.autoconfigure;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.spring.boot.autoconfigure.NatsProperties;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={Connection.class})
@EnableConfigurationProperties(value={NatsProperties.class})
public class NatsAutoConfiguration {
    private static final Log logger = LogFactory.getLog(NatsAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Connection natsConnection(NatsProperties properties, ConnectionListener connectionListener, ErrorListener errorListener) throws IOException, InterruptedException, GeneralSecurityException {
        String serverProp;
        Connection nc = null;
        String string = serverProp = properties != null ? properties.getServer() : null;
        if (serverProp == null || serverProp.length() == 0) {
            return null;
        }
        try {
            logger.info((Object)("autoconnecting to NATS with properties - " + properties));
            Options.Builder builder = properties.toOptionsBuilder();
            builder = builder.connectionListener(connectionListener);
            builder = builder.errorListener(errorListener);
            nc = Nats.connect((Options)builder.build());
        }
        catch (Exception e) {
            logger.info((Object)"error connecting to nats", (Throwable)e);
            throw e;
        }
        return nc;
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionListener defaultConnectionListener() {
        return new ConnectionListener(){

            public void connectionEvent(Connection conn, ConnectionListener.Events type) {
                logger.info((Object)("NATS connection status changed " + type));
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorListener defaultErrorListener() {
        return new ErrorListener(){

            public void slowConsumerDetected(Connection conn, Consumer consumer) {
                logger.info((Object)"NATS connection slow consumer detected");
            }

            public void exceptionOccurred(Connection conn, Exception exp) {
                logger.info((Object)"NATS connection exception occurred", (Throwable)exp);
            }

            public void errorOccurred(Connection conn, String error) {
                logger.info((Object)("NATS connection error occurred " + error));
            }
        };
    }
}

