/*
 * Decompiled with CFR 0.152.
 */
package io.nats.spring;

import io.nats.spring.PollingSample;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.MessageChannel;

@SpringBootApplication
@EnableBinding(value={PolledProcessor.class})
public class PollingSample {
    private static final Log logger = LogFactory.getLog(PollingSample.class);
    public static final ExecutorService exec = Executors.newSingleThreadExecutor();

    public static void main(String[] args) {
        SpringApplication.run(PollingSample.class, (String[])args);
    }

    @Bean
    public ApplicationRunner runner(PollableMessageSource input, MessageChannel output) {
        return args -> exec.execute(() -> {
            while (true) {
                input.poll(message -> {
                    byte[] bytes = (byte[])message.getPayload();
                    String val = new String(bytes, StandardCharsets.UTF_8);
                    logger.info((Object)("received message " + val));
                });
            }
        });
    }
}

