/*
 * Decompiled with CFR 0.152.
 */
package io.nayuki.qrcodegen;

import io.nayuki.qrcodegen.BitBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public final class QrSegment {
    public final Mode mode;
    public final int numChars;
    final BitBuffer data;
    public static final Pattern NUMERIC_REGEX = Pattern.compile("[0-9]*");
    public static final Pattern ALPHANUMERIC_REGEX = Pattern.compile("[A-Z0-9 $%*+./:-]*");
    static final String ALPHANUMERIC_CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:";

    public static QrSegment makeBytes(byte[] data) {
        Objects.requireNonNull(data);
        BitBuffer bb = new BitBuffer();
        for (byte b : data) {
            bb.appendBits(b & 0xFF, 8);
        }
        return new QrSegment(Mode.BYTE, data.length, bb);
    }

    public static QrSegment makeNumeric(String digits) {
        int n;
        Objects.requireNonNull(digits);
        if (!NUMERIC_REGEX.matcher(digits).matches()) {
            throw new IllegalArgumentException("String contains non-numeric characters");
        }
        BitBuffer bb = new BitBuffer();
        for (int i = 0; i < digits.length(); i += n) {
            n = Math.min(digits.length() - i, 3);
            bb.appendBits(Integer.parseInt(digits.substring(i, i + n)), n * 3 + 1);
        }
        return new QrSegment(Mode.NUMERIC, digits.length(), bb);
    }

    public static QrSegment makeAlphanumeric(String text) {
        int i;
        Objects.requireNonNull(text);
        if (!ALPHANUMERIC_REGEX.matcher(text).matches()) {
            throw new IllegalArgumentException("String contains unencodable characters in alphanumeric mode");
        }
        BitBuffer bb = new BitBuffer();
        for (i = 0; i <= text.length() - 2; i += 2) {
            int temp = ALPHANUMERIC_CHARSET.indexOf(text.charAt(i)) * 45;
            bb.appendBits(temp += ALPHANUMERIC_CHARSET.indexOf(text.charAt(i + 1)), 11);
        }
        if (i < text.length()) {
            bb.appendBits(ALPHANUMERIC_CHARSET.indexOf(text.charAt(i)), 6);
        }
        return new QrSegment(Mode.ALPHANUMERIC, text.length(), bb);
    }

    public static List<QrSegment> makeSegments(String text) {
        Objects.requireNonNull(text);
        ArrayList<QrSegment> result = new ArrayList<QrSegment>();
        if (!text.equals("")) {
            if (NUMERIC_REGEX.matcher(text).matches()) {
                result.add(QrSegment.makeNumeric(text));
            } else if (ALPHANUMERIC_REGEX.matcher(text).matches()) {
                result.add(QrSegment.makeAlphanumeric(text));
            } else {
                result.add(QrSegment.makeBytes(text.getBytes(StandardCharsets.UTF_8)));
            }
        }
        return result;
    }

    public static QrSegment makeEci(int assignVal) {
        BitBuffer bb = new BitBuffer();
        if (assignVal < 0) {
            throw new IllegalArgumentException("ECI assignment value out of range");
        }
        if (assignVal < 128) {
            bb.appendBits(assignVal, 8);
        } else if (assignVal < 16384) {
            bb.appendBits(2, 2);
            bb.appendBits(assignVal, 14);
        } else if (assignVal < 1000000) {
            bb.appendBits(6, 3);
            bb.appendBits(assignVal, 21);
        } else {
            throw new IllegalArgumentException("ECI assignment value out of range");
        }
        return new QrSegment(Mode.ECI, 0, bb);
    }

    public QrSegment(Mode md, int numCh, BitBuffer data) {
        this.mode = Objects.requireNonNull(md);
        Objects.requireNonNull(data);
        if (numCh < 0) {
            throw new IllegalArgumentException("Invalid value");
        }
        this.numChars = numCh;
        this.data = data.clone();
    }

    public BitBuffer getData() {
        return this.data.clone();
    }

    static int getTotalBits(List<QrSegment> segs, int version) {
        Objects.requireNonNull(segs);
        long result = 0L;
        for (QrSegment seg : segs) {
            Objects.requireNonNull(seg);
            int ccbits = seg.mode.numCharCountBits(version);
            if (seg.numChars >= 1 << ccbits) {
                return -1;
            }
            if ((result += 4L + (long)ccbits + (long)seg.data.bitLength()) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)result;
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NUMERIC = new Mode(1, 10, 12, 14);
        public static final /* enum */ Mode ALPHANUMERIC = new Mode(2, 9, 11, 13);
        public static final /* enum */ Mode BYTE = new Mode(4, 8, 16, 16);
        public static final /* enum */ Mode KANJI = new Mode(8, 8, 10, 12);
        public static final /* enum */ Mode ECI = new Mode(7, 0, 0, 0);
        final int modeBits;
        private final int[] numBitsCharCount;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String name) {
            return Enum.valueOf(Mode.class, name);
        }

        private Mode(int mode, int ... ccbits) {
            this.modeBits = mode;
            this.numBitsCharCount = ccbits;
        }

        int numCharCountBits(int ver) {
            assert (1 <= ver && ver <= 40);
            return this.numBitsCharCount[(ver + 7) / 17];
        }

        static {
            $VALUES = new Mode[]{NUMERIC, ALPHANUMERIC, BYTE, KANJI, ECI};
        }
    }
}

