/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.annotations.VisibleForTesting;
import io.neonbee.NeonBee;
import io.neonbee.NeonBeeOptions;
import io.neonbee.config.NeonBeeConfig;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLI;
import io.vertx.core.cli.CLIException;
import io.vertx.core.cli.CommandLine;
import io.vertx.core.cli.Option;
import io.vertx.core.cli.annotations.CLIConfigurator;
import io.vertx.core.cli.impl.DefaultCommandLine;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Option HELP_FLAG = new Option().setLongName("help").setShortName("h").setDescription("Show help").setFlag(true).setHelp(true);
    private static final String HAZELCAST_LOGGING_TYPE = "hazelcast.logging.type";
    private static final String INFINISPAN_LOGGING_TYPE = "org.jboss.logging.provider";
    private static final String LOG_DIR_PROPERTY = "LOG_DIR";
    @VisibleForTesting
    static final CLI INTERFACE = CLI.create(NeonBeeOptions.Mutable.class).addOption(HELP_FLAG);
    private static NeonBee neonBee;

    public static void main(String[] args) {
        CommandLine commandLine = Launcher.commandLine(args);
        NeonBeeOptions.Mutable options = Launcher.createNeonBeeOptions(commandLine);
        Launcher.startNeonBee(options);
    }

    public static void startNeonBee(NeonBeeOptions options) {
        Launcher.configureLogging(options);
        Vertx launcherVertx = Vertx.vertx();
        Future.succeededFuture().compose(unused -> NeonBeeConfig.load(launcherVertx, options.getConfigDirectory())).eventually(unused -> Launcher.closeVertx(launcherVertx)).compose(config -> NeonBee.create(options, config)).onSuccess(neonBee -> {
            Launcher.neonBee = neonBee;
        }).onFailure(throwable -> LoggerFactory.getLogger(Launcher.class).error("Failed to start NeonBee", throwable));
    }

    public static NeonBeeOptions.Mutable createNeonBeeOptions(CommandLine commandLine) {
        NeonBeeOptions.Mutable options = new NeonBeeOptions.Mutable();
        CLIConfigurator.inject((CommandLine)commandLine, (Object)options);
        return options;
    }

    public static CommandLine commandLine(String ... args) {
        CommandLine commandLine = null;
        try {
            commandLine = Launcher.parseCommandLine(args);
            List arguments = commandLine.allArguments();
            if (!arguments.isEmpty()) {
                throw new CLIException("Unknown option '" + (String)arguments.get(0) + "'");
            }
        }
        catch (CLIException e) {
            System.err.print(e.getMessage() + ".\n\nUse --help to list all options.");
            System.exit(1);
        }
        if (commandLine.isAskingForHelp()) {
            StringBuilder builder = new StringBuilder();
            INTERFACE.usage(builder);
            System.out.print(builder);
            System.exit(0);
        }
        return commandLine;
    }

    private static void configureLogging(NeonBeeOptions options) {
        System.setProperty("logback.configurationFile", options.getConfigDirectory().resolve("logback.xml").toString());
        System.setProperty(HAZELCAST_LOGGING_TYPE, "slf4j");
        System.setProperty(INFINISPAN_LOGGING_TYPE, "slf4j");
        System.setProperty(LOG_DIR_PROPERTY, options.getLogDirectory().toAbsolutePath().toString());
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
    }

    private static Future<Void> closeVertx(Vertx launcherVertx) {
        Promise promise = Promise.promise();
        launcherVertx.close((Handler)promise);
        return promise.future();
    }

    @VisibleForTesting
    static CommandLine parseCommandLine(String[] args) {
        return new EnvironmentAwareCommandLine(INTERFACE.parse(List.of(args), true));
    }

    @VisibleForTesting
    static class EnvironmentAwareCommandLine
    extends DefaultCommandLine {
        EnvironmentAwareCommandLine(CommandLine commandLine) {
            super(commandLine.cli());
            CLI cli = commandLine.cli();
            DefaultCommandLine defaultCommandLine = (DefaultCommandLine)commandLine;
            this.allArgs = defaultCommandLine.allArguments();
            cli.getOptions().forEach(option -> {
                this.optionValues.put(option, defaultCommandLine.getRawValuesForOption(option));
                if (defaultCommandLine.isSeenInCommandLine(option)) {
                    this.optionsSeenInCommandLine.add(option);
                }
            });
            cli.getArguments().forEach(argument -> this.argumentValues.put(argument, defaultCommandLine.getRawValuesForArgument(argument)));
            this.valid = defaultCommandLine.isValid();
        }

        public boolean isFlagEnabled(String name) {
            return super.isFlagEnabled(name) || this.hasEnvArg(this.cli().getOption(name));
        }

        public boolean isSeenInCommandLine(Option option) {
            return super.isSeenInCommandLine(option) || this.hasEnvArg(option);
        }

        public boolean isOptionAssigned(Option option) {
            return !super.getRawValuesForOption(option).isEmpty() || this.hasEnvArg(option);
        }

        public List<String> getRawValuesForOption(Option option) {
            List values = super.getRawValuesForOption(option);
            if (!values.isEmpty()) {
                return values;
            }
            if (this.hasEnvArg(option)) {
                return List.of(this.getEnvArg(option));
            }
            String value = option.getDefaultValue();
            if (value != null) {
                return List.of(value);
            }
            return Collections.emptyList();
        }

        @VisibleForTesting
        String getEnvArg(Option option) {
            return System.getenv(EnvironmentAwareCommandLine.getEnvName(option));
        }

        @VisibleForTesting
        boolean hasEnvArg(Option option) {
            return System.getenv().containsKey(EnvironmentAwareCommandLine.getEnvName(option));
        }

        static String getEnvName(Option option) {
            return "NEONBEE_" + option.getName().replace("-", "_").toUpperCase(Locale.ROOT);
        }
    }
}

