/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee;

import com.google.common.base.Enums;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum NeonBeeProfile {
    WEB,
    CORE,
    STABLE,
    INCUBATOR,
    NO_WEB,
    ALL;


    public boolean isActive(Collection<NeonBeeProfile> activeProfiles) {
        if (activeProfiles.isEmpty() || activeProfiles.contains((Object)NO_WEB) && this == WEB) {
            return false;
        }
        return activeProfiles.contains((Object)ALL) || activeProfiles.contains((Object)this) || this == ALL;
    }

    public static NeonBeeProfile getProfile(String profile) {
        return (NeonBeeProfile)((Object)Enums.getIfPresent(NeonBeeProfile.class, (String)profile).orNull());
    }

    public static Set<NeonBeeProfile> parseProfiles(String profiles) {
        return Optional.ofNullable(profiles).map(nonNullProfiles -> Arrays.stream(nonNullProfiles.split(",")).filter(Predicate.not(String::isBlank)).map(NeonBeeProfile::getProfile).filter(Objects::nonNull).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }
}

