/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.errorprone.annotations.Immutable;
import io.neonbee.config.AuthProviderConfigConverter;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataObject(generateConverter=true, publicConverter=false)
public class AuthProviderConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AuthProviderType type;
    private JsonObject additionalConfig = new JsonObject();

    public AuthProviderConfig() {
    }

    public AuthProviderConfig(JsonObject json) {
        this();
        AuthProviderConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.additionalConfig.mergeIn(ConfigHelper.collectAdditionalConfig(json, "type"));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        AuthProviderConfigConverter.toJson(this, json);
        Optional.ofNullable(this.additionalConfig).ifPresent(config -> json.mergeIn(config));
        return json;
    }

    public AuthProviderType getType() {
        return this.type;
    }

    @Fluent
    public AuthProviderConfig setType(AuthProviderType type) {
        this.type = type;
        return this;
    }

    @GenIgnore
    public JsonObject getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Fluent
    @GenIgnore
    public AuthProviderConfig setAdditionalConfig(JsonObject additionalConfig) {
        this.additionalConfig = Optional.ofNullable(additionalConfig).orElseGet(JsonObject::new);
        return this;
    }

    public AuthenticationProvider createAuthProvider(Vertx vertx) {
        return this.type.createAuthProvider(vertx, this.additionalConfig);
    }

    public int hashCode() {
        return Objects.hash(this.additionalConfig, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthProviderConfig)) {
            return false;
        }
        AuthProviderConfig other = (AuthProviderConfig)obj;
        return Objects.equals(this.additionalConfig, other.additionalConfig) && this.type == other.type;
    }

    @Immutable
    public static enum AuthProviderType implements AuthProviderFactory
    {
        HTDIGEST((vertx, additionalConfig) -> HtdigestAuth.create((Vertx)vertx, (String)additionalConfig.getString("htfile", ".htdigest"))),
        HTPASSWD((vertx, additionalConfig) -> HtpasswdAuth.create((Vertx)vertx, (HtpasswdAuthOptions)new HtpasswdAuthOptions(additionalConfig))),
        JDBC((vertx, additionalConfig) -> {
            throw new UnsupportedOperationException("JDBC authentication provider is not implemented yet");
        }),
        JWT((vertx, additionalConfig) -> JWTAuth.create((Vertx)vertx, (JWTAuthOptions)new JWTAuthOptions(additionalConfig))),
        MONGO((vertx, additionalConfig) -> {
            throw new UnsupportedOperationException("MongoDB authentication provider is not implemented yet");
        }),
        OAUTH2((vertx, additionalConfig) -> OAuth2Auth.create((Vertx)vertx, (OAuth2Options)new OAuth2Options(additionalConfig)));

        final AuthProviderFactory factory;

        private AuthProviderType(AuthProviderFactory factory) {
            this.factory = factory;
        }

        @Override
        public AuthenticationProvider createAuthProvider(Vertx vertx, JsonObject additionalConfig) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Configuring auth. provider {} with options: {}", (Object)this, (Object)additionalConfig);
            }
            return this.factory.createAuthProvider(vertx, Optional.ofNullable(additionalConfig).orElse(ImmutableJsonObject.EMPTY));
        }
    }

    @Immutable
    @FunctionalInterface
    private static interface AuthProviderFactory {
        public AuthenticationProvider createAuthProvider(Vertx var1, JsonObject var2);
    }
}

