/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.collect.ImmutableBiMap;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfigConverter;
import io.neonbee.internal.helper.ConfigHelper;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@DataObject(generateConverter=true, publicConverter=false)
public class EndpointConfig {
    private static final ImmutableBiMap<String, String> REPHRASE_MAP = ImmutableBiMap.of((Object)"authChainConfig", (Object)"authenticationChain");
    private String type;
    private String basePath;
    private Boolean enabled = true;
    private List<AuthHandlerConfig> authChainConfig;
    private JsonObject additionalConfig = new JsonObject();

    public EndpointConfig() {
    }

    public EndpointConfig(JsonObject json) {
        this();
        JsonObject newJson = ConfigHelper.rephraseConfigNames(json.copy(), REPHRASE_MAP, true);
        EndpointConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)newJson, this);
        this.additionalConfig.mergeIn(ConfigHelper.collectAdditionalConfig(newJson, "type", "basePath", "enabled", "authChainConfig"));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        EndpointConfigConverter.toJson(this, json);
        json.mergeIn(this.additionalConfig);
        ConfigHelper.rephraseConfigNames(json, REPHRASE_MAP, false);
        return json;
    }

    public String getType() {
        return this.type;
    }

    @Fluent
    public EndpointConfig setType(String type) {
        this.type = type;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Fluent
    public EndpointConfig setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    @Fluent
    public EndpointConfig setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<AuthHandlerConfig> getAuthChainConfig() {
        return this.authChainConfig;
    }

    @Fluent
    public EndpointConfig setAuthChainConfig(List<AuthHandlerConfig> authChainConfig) {
        this.authChainConfig = authChainConfig;
        return this;
    }

    @GenIgnore
    public JsonObject getAdditionalConfig() {
        return this.additionalConfig;
    }

    @Fluent
    @GenIgnore
    public EndpointConfig setAdditionalConfig(JsonObject additionalConfig) {
        this.additionalConfig = Optional.ofNullable(additionalConfig).orElseGet(JsonObject::new);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.additionalConfig, this.authChainConfig, this.basePath, this.enabled, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EndpointConfig)) {
            return false;
        }
        EndpointConfig other = (EndpointConfig)obj;
        return Objects.equals(this.additionalConfig, other.additionalConfig) && Objects.equals(this.authChainConfig, other.authChainConfig) && Objects.equals(this.basePath, other.basePath) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.type, other.type);
    }
}

