/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import io.neonbee.config.HealthConfig;
import io.neonbee.config.MetricsConfig;
import io.neonbee.config.MicrometerRegistryConfig;
import io.neonbee.config.NeonBeeConfig;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class NeonBeeConfigConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NeonBeeConfig obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "eventBusCodecs": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setEventBusCodecs(map);
                    break;
                }
                case "eventBusTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setEventBusTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "healthConfig": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHealthConfig(new HealthConfig((JsonObject)member.getValue()));
                    break;
                }
                case "metricsConfig": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setMetricsConfig(new MetricsConfig((JsonObject)member.getValue()));
                    break;
                }
                case "micrometerRegistries": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<MicrometerRegistryConfig> list = new ArrayList<MicrometerRegistryConfig>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new MicrometerRegistryConfig((JsonObject)item));
                        }
                    });
                    obj.setMicrometerRegistries(list);
                    break;
                }
                case "platformClasses": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<MicrometerRegistryConfig> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((MicrometerRegistryConfig)((Object)((String)item)));
                        }
                    });
                    obj.setPlatformClasses(list);
                    break;
                }
                case "timeZone": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTimeZone((String)member.getValue());
                    break;
                }
                case "trackingDataHandlingStrategy": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTrackingDataHandlingStrategy((String)member.getValue());
                }
            }
        }
    }

    static void toJson(NeonBeeConfig obj, JsonObject json) {
        NeonBeeConfigConverter.toJson(obj, json.getMap());
    }

    static void toJson(NeonBeeConfig obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getEventBusCodecs() != null) {
            JsonObject map = new JsonObject();
            obj.getEventBusCodecs().forEach((key, value) -> map.put(key, value));
            json.put("eventBusCodecs", map);
        }
        json.put("eventBusTimeout", obj.getEventBusTimeout());
        if (obj.getHealthConfig() != null) {
            json.put("healthConfig", obj.getHealthConfig().toJson());
        }
        if (obj.getMetricsConfig() != null) {
            json.put("metricsConfig", obj.getMetricsConfig().toJson());
        }
        if (obj.getMicrometerRegistries() != null) {
            array = new JsonArray();
            obj.getMicrometerRegistries().forEach(item -> array.add((Object)item.toJson()));
            json.put("micrometerRegistries", array);
        }
        if (obj.getPlatformClasses() != null) {
            array = new JsonArray();
            obj.getPlatformClasses().forEach(item -> array.add(item));
            json.put("platformClasses", array);
        }
        if (obj.getTimeZone() != null) {
            json.put("timeZone", obj.getTimeZone());
        }
        if (obj.getTrackingDataHandlingStrategy() != null) {
            json.put("trackingDataHandlingStrategy", obj.getTrackingDataHandlingStrategy());
        }
    }
}

