/*
 * Decompiled with CFR 0.152.
 */
package io.neonbee.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableBiMap;
import io.neonbee.config.AuthHandlerConfig;
import io.neonbee.config.EndpointConfig;
import io.neonbee.config.ServerConfigConverter;
import io.neonbee.endpoint.health.HealthEndpoint;
import io.neonbee.endpoint.metrics.MetricsEndpoint;
import io.neonbee.endpoint.odatav4.ODataV4Endpoint;
import io.neonbee.endpoint.raw.RawEndpoint;
import io.neonbee.internal.handler.factories.CacheControlHandlerFactory;
import io.neonbee.internal.handler.factories.CorrelationIdHandlerFactory;
import io.neonbee.internal.handler.factories.DisallowingFileUploadBodyHandlerFactory;
import io.neonbee.internal.handler.factories.InstanceInfoHandlerFactory;
import io.neonbee.internal.handler.factories.LoggerHandlerFactory;
import io.neonbee.internal.handler.factories.SessionHandlerFactory;
import io.neonbee.internal.handler.factories.TimeoutHandlerFactory;
import io.neonbee.internal.helper.ConfigHelper;
import io.neonbee.internal.json.ImmutableJsonObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DataObject(generateConverter=true, publicConverter=false)
public class ServerConfig
extends HttpServerOptions {
    public static final int DEFAULT_PORT = 8080;
    public static final boolean DEFAULT_USE_ALPN = true;
    public static final boolean DEFAULT_COMPRESSION_SUPPORTED = true;
    public static final int DEFAULT_COMPRESSION_LEVEL = 1;
    public static final boolean DEFAULT_DECOMPRESSION_SUPPORTED = true;
    public static final int DEFAULT_TIMEOUT = 30;
    public static final String DEFAULT_SESSION_COOKIE_NAME = "neonbee-web.session";
    public static final List<String> DEFAULT_HANDLER_FACTORIES_CLASS_NAMES = List.of(LoggerHandlerFactory.class.getName(), InstanceInfoHandlerFactory.class.getName(), CorrelationIdHandlerFactory.class.getName(), TimeoutHandlerFactory.class.getName(), SessionHandlerFactory.class.getName(), CacheControlHandlerFactory.class.getName(), DisallowingFileUploadBodyHandlerFactory.class.getName());
    private static final String PROPERTY_PORT = "port";
    private static final List<EndpointConfig> DEFAULT_ENDPOINT_CONFIGS = Collections.unmodifiableList(Stream.of(RawEndpoint.class, ODataV4Endpoint.class, MetricsEndpoint.class, HealthEndpoint.class).map(endpointClass -> new EndpointConfig().setType(endpointClass.getName())).collect(Collectors.toList()));
    private static final ImmutableBiMap<String, String> REPHRASE_MAP = ImmutableBiMap.of((Object)"endpointConfigs", (Object)"endpoints", (Object)"authChainConfig", (Object)"authenticationChain", (Object)"errorHandlerClassName", (Object)"errorHandler", (Object)"errorHandlerTemplate", (Object)"errorTemplate", (Object)"handlerFactoriesClassNames", (Object)"handlerFactories");
    private int timeout = 30;
    private int timeoutStatusCode = HttpResponseStatus.GATEWAY_TIMEOUT.code();
    private SessionHandling sessionHandling = SessionHandling.NONE;
    private String sessionCookieName = "neonbee-web.session";
    private CorrelationStrategy correlationStrategy = CorrelationStrategy.REQUEST_HEADER;
    private List<EndpointConfig> endpointConfigs = new ArrayList<EndpointConfig>(DEFAULT_ENDPOINT_CONFIGS);
    private List<AuthHandlerConfig> authChainConfig;
    private List<String> handlerFactoriesClassNames = DEFAULT_HANDLER_FACTORIES_CLASS_NAMES;
    private String errorHandlerClassName;
    private String errorHandlerTemplate;

    public ServerConfig() {
        this.overrideDefaults(ImmutableJsonObject.EMPTY);
    }

    public ServerConfig(JsonObject json) {
        super(json);
        JsonObject newJson = ConfigHelper.rephraseConfigNames(json.copy(), REPHRASE_MAP, true);
        this.overrideDefaults(newJson);
        ServerConfigConverter.fromJson((Iterable<Map.Entry<String, Object>>)newJson, this);
    }

    private void overrideDefaults(JsonObject json) {
        this.setPort(json.getInteger(PROPERTY_PORT, Integer.valueOf(8080)));
        this.setUseAlpn(json.getBoolean("useAlpn", Boolean.valueOf(true)));
        this.setCompressionSupported(json.getBoolean("compressionSupported", Boolean.valueOf(true)));
        this.setCompressionLevel(json.getInteger("compressionLevel", Integer.valueOf(1)));
        this.setDecompressionSupported(json.getBoolean("decompressionSupported", Boolean.valueOf(true)));
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ServerConfigConverter.toJson(this, json);
        ConfigHelper.rephraseConfigNames(json, REPHRASE_MAP, false);
        return json;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @Fluent
    public ServerConfig setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SessionHandling getSessionHandling() {
        return this.sessionHandling;
    }

    @Fluent
    public ServerConfig setSessionHandling(SessionHandling sessionHandling) {
        this.sessionHandling = sessionHandling;
        return this;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    @Fluent
    public ServerConfig setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    public CorrelationStrategy getCorrelationStrategy() {
        return this.correlationStrategy;
    }

    @Fluent
    public ServerConfig setCorrelationStrategy(CorrelationStrategy correlationStrategy) {
        this.correlationStrategy = correlationStrategy;
        return this;
    }

    public int getTimeoutStatusCode() {
        return this.timeoutStatusCode;
    }

    @Fluent
    public ServerConfig setTimeoutStatusCode(int timeoutStatusCode) {
        this.timeoutStatusCode = timeoutStatusCode;
        return this;
    }

    public List<EndpointConfig> getEndpointConfigs() {
        return this.endpointConfigs;
    }

    @Fluent
    public ServerConfig setEndpointConfigs(List<EndpointConfig> endpointConfigs) {
        this.endpointConfigs = endpointConfigs;
        return this;
    }

    public List<AuthHandlerConfig> getAuthChainConfig() {
        return this.authChainConfig;
    }

    @Fluent
    public ServerConfig setAuthChainConfig(List<AuthHandlerConfig> authChainConfig) {
        this.authChainConfig = authChainConfig;
        return this;
    }

    public List<String> getHandlerFactoriesClassNames() {
        return this.handlerFactoriesClassNames;
    }

    @Fluent
    public ServerConfig setHandlerFactoriesClassNames(List<String> handlerFactoriesClassNames) {
        this.handlerFactoriesClassNames = handlerFactoriesClassNames;
        return this;
    }

    public String getErrorHandlerClassName() {
        return this.errorHandlerClassName;
    }

    @Fluent
    public ServerConfig setErrorHandlerClassName(String errorHandlerClassName) {
        this.errorHandlerClassName = errorHandlerClassName;
        return this;
    }

    public String getErrorHandlerTemplate() {
        return this.errorHandlerTemplate;
    }

    @Fluent
    public ServerConfig setErrorHandlerTemplate(String errorHandlerTemplate) {
        this.errorHandlerTemplate = errorHandlerTemplate;
        return this;
    }

    public ServerConfig addCrlPath(String crlPath) {
        super.addCrlPath(crlPath);
        return this;
    }

    public ServerConfig addCrlValue(Buffer crlValue) {
        super.addCrlValue(crlValue);
        return this;
    }

    public ServerConfig addEnabledCipherSuite(String suite) {
        super.addEnabledCipherSuite(suite);
        return this;
    }

    public ServerConfig addEnabledSecureTransportProtocol(String protocol) {
        super.addEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public ServerConfig addWebSocketSubProtocol(String subProtocol) {
        super.addWebSocketSubProtocol(subProtocol);
        return this;
    }

    public ServerConfig removeEnabledSecureTransportProtocol(String protocol) {
        super.removeEnabledSecureTransportProtocol(protocol);
        return this;
    }

    public ServerConfig setAcceptBacklog(int acceptBacklog) {
        super.setAcceptBacklog(acceptBacklog);
        return this;
    }

    public ServerConfig setAcceptUnmaskedFrames(boolean acceptUnmaskedFrames) {
        super.setAcceptUnmaskedFrames(acceptUnmaskedFrames);
        return this;
    }

    public ServerConfig setAlpnVersions(List<HttpVersion> alpnVersions) {
        super.setAlpnVersions(alpnVersions);
        return this;
    }

    public ServerConfig setClientAuth(ClientAuth clientAuth) {
        super.setClientAuth(clientAuth);
        return this;
    }

    public ServerConfig setCompressionLevel(int compressionLevel) {
        super.setCompressionLevel(compressionLevel);
        return this;
    }

    public ServerConfig setCompressionSupported(boolean compressionSupported) {
        super.setCompressionSupported(compressionSupported);
        return this;
    }

    public ServerConfig setDecoderInitialBufferSize(int decoderInitialBufferSize) {
        super.setDecoderInitialBufferSize(decoderInitialBufferSize);
        return this;
    }

    public ServerConfig setDecompressionSupported(boolean decompressionSupported) {
        super.setDecompressionSupported(decompressionSupported);
        return this;
    }

    public ServerConfig setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
        return this;
    }

    public ServerConfig setHandle100ContinueAutomatically(boolean handle100ContinueAutomatically) {
        super.setHandle100ContinueAutomatically(handle100ContinueAutomatically);
        return this;
    }

    public ServerConfig setHost(String host) {
        super.setHost(host);
        return this;
    }

    public ServerConfig setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        super.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
        return this;
    }

    public ServerConfig setIdleTimeout(int idleTimeout) {
        super.setIdleTimeout(idleTimeout);
        return this;
    }

    public ServerConfig setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        super.setIdleTimeoutUnit(idleTimeoutUnit);
        return this;
    }

    public ServerConfig setInitialSettings(Http2Settings settings) {
        super.setInitialSettings(settings);
        return this;
    }

    public ServerConfig setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        super.setJdkSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ServerConfig setKeyCertOptions(KeyCertOptions options) {
        super.setKeyCertOptions(options);
        return this;
    }

    public ServerConfig setKeyStoreOptions(JksOptions options) {
        super.setKeyStoreOptions(options);
        return this;
    }

    public ServerConfig setLogActivity(boolean logEnabled) {
        super.setLogActivity(logEnabled);
        return this;
    }

    public ServerConfig setMaxChunkSize(int maxChunkSize) {
        super.setMaxChunkSize(maxChunkSize);
        return this;
    }

    public ServerConfig setMaxHeaderSize(int maxHeaderSize) {
        super.setMaxHeaderSize(maxHeaderSize);
        return this;
    }

    public ServerConfig setMaxInitialLineLength(int maxInitialLineLength) {
        super.setMaxInitialLineLength(maxInitialLineLength);
        return this;
    }

    public ServerConfig setMaxWebSocketFrameSize(int maxWebSocketFrameSize) {
        super.setMaxWebSocketFrameSize(maxWebSocketFrameSize);
        return this;
    }

    public ServerConfig setMaxWebSocketMessageSize(int maxWebSocketMessageSize) {
        super.setMaxWebSocketMessageSize(maxWebSocketMessageSize);
        return this;
    }

    public ServerConfig setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        super.setOpenSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ServerConfig setPemKeyCertOptions(PemKeyCertOptions options) {
        super.setPemKeyCertOptions(options);
        return this;
    }

    public ServerConfig setPemTrustOptions(PemTrustOptions options) {
        super.setPemTrustOptions(options);
        return this;
    }

    public ServerConfig setPerFrameWebSocketCompressionSupported(boolean supported) {
        super.setPerFrameWebSocketCompressionSupported(supported);
        return this;
    }

    public ServerConfig setPerMessageWebSocketCompressionSupported(boolean supported) {
        super.setPerMessageWebSocketCompressionSupported(supported);
        return this;
    }

    public ServerConfig setPfxKeyCertOptions(PfxOptions options) {
        super.setPfxKeyCertOptions(options);
        return this;
    }

    public ServerConfig setPfxTrustOptions(PfxOptions options) {
        super.setPfxTrustOptions(options);
        return this;
    }

    public ServerConfig setPort(int port) {
        super.setPort(port);
        return this;
    }

    public ServerConfig setProxyProtocolTimeout(long proxyProtocolTimeout) {
        super.setProxyProtocolTimeout(proxyProtocolTimeout);
        return this;
    }

    public ServerConfig setProxyProtocolTimeoutUnit(TimeUnit proxyProtocolTimeoutUnit) {
        super.setProxyProtocolTimeoutUnit(proxyProtocolTimeoutUnit);
        return this;
    }

    public ServerConfig setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
        return this;
    }

    public ServerConfig setReuseAddress(boolean reuseAddress) {
        super.setReuseAddress(reuseAddress);
        return this;
    }

    public ServerConfig setReusePort(boolean reusePort) {
        super.setReusePort(reusePort);
        return this;
    }

    public ServerConfig setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
        return this;
    }

    public ServerConfig setSni(boolean sni) {
        super.setSni(sni);
        return this;
    }

    public ServerConfig setSoLinger(int soLinger) {
        super.setSoLinger(soLinger);
        return this;
    }

    public ServerConfig setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public ServerConfig setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        super.setSslEngineOptions(sslEngineOptions);
        return this;
    }

    public ServerConfig setSslHandshakeTimeout(long sslHandshakeTimeout) {
        super.setSslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    public ServerConfig setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
        return this;
    }

    public ServerConfig setTcpCork(boolean tcpCork) {
        super.setTcpCork(tcpCork);
        return this;
    }

    public ServerConfig setTcpFastOpen(boolean tcpFastOpen) {
        super.setTcpFastOpen(tcpFastOpen);
        return this;
    }

    public ServerConfig setTcpKeepAlive(boolean tcpKeepAlive) {
        super.setTcpKeepAlive(tcpKeepAlive);
        return this;
    }

    public ServerConfig setTcpNoDelay(boolean tcpNoDelay) {
        super.setTcpNoDelay(tcpNoDelay);
        return this;
    }

    public ServerConfig setTcpQuickAck(boolean tcpQuickAck) {
        super.setTcpQuickAck(tcpQuickAck);
        return this;
    }

    public ServerConfig setTracingPolicy(TracingPolicy tracingPolicy) {
        super.setTracingPolicy(tracingPolicy);
        return this;
    }

    public ServerConfig setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
        return this;
    }

    public ServerConfig setTrustOptions(TrustOptions options) {
        super.setTrustOptions(options);
        return this;
    }

    public ServerConfig setTrustStoreOptions(JksOptions options) {
        super.setTrustStoreOptions(options);
        return this;
    }

    public ServerConfig setUseAlpn(boolean useAlpn) {
        super.setUseAlpn(useAlpn);
        return this;
    }

    public ServerConfig setUseProxyProtocol(boolean useProxyProtocol) {
        super.setUseProxyProtocol(useProxyProtocol);
        return this;
    }

    public ServerConfig setWebSocketAllowServerNoContext(boolean accept) {
        super.setWebSocketAllowServerNoContext(accept);
        return this;
    }

    public ServerConfig setWebSocketCompressionLevel(int compressionLevel) {
        super.setWebSocketCompressionLevel(compressionLevel);
        return this;
    }

    public ServerConfig setWebSocketPreferredClientNoContext(boolean accept) {
        super.setWebSocketPreferredClientNoContext(accept);
        return this;
    }

    public ServerConfig setWebSocketSubProtocols(List<String> subProtocols) {
        super.setWebSocketSubProtocols(subProtocols);
        return this;
    }

    public static enum SessionHandling {
        NONE,
        LOCAL,
        CLUSTERED;

    }

    public static enum CorrelationStrategy {
        GENERATE_UUID(routingContext -> UUID.randomUUID().toString()),
        REQUEST_HEADER(routingContext -> {
            HttpServerRequest request = routingContext.request();
            String correlationId = request.getHeader("X-CorrelationID");
            if (Strings.isNullOrEmpty((String)correlationId)) {
                correlationId = request.getHeader("x-vcap-request-id");
            }
            if (Strings.isNullOrEmpty((String)correlationId)) {
                correlationId = GENERATE_UUID.getCorrelationId((RoutingContext)routingContext);
            }
            return correlationId;
        });

        final Function<RoutingContext, String> mapper;

        private CorrelationStrategy(Function<RoutingContext, String> mapper) {
            this.mapper = mapper;
        }

        public String getCorrelationId(RoutingContext routingContext) {
            return this.mapper.apply(routingContext);
        }
    }
}

